#include "files.h"

#include <sys/types.h>
#include <sys/stat.h>

#define  CANNOT_OPEN(string, file) \
         {   sprintf(error_msg, "opening \"%s\" for %s", \
                                file, string);  return  ERROR;   }

static long file_size(String file)
{
    long size;
    struct stat data;

    if (lstat(file, &data))
	return  0; /* arbitrary */

    size = (long) data.st_size;

    return size;
}

void close_files(File_info *file_info)
{
    if (file_info->file_in == file_info->file_out)
    {
	FCLOSE(file_info->file_in);
    }
    else
    {
	FCLOSE(file_info->file_in);
	FCLOSE(file_info->file_out);
    }
}

Status open_files(File_info *file_info, String error_msg)
{
    String input_file, output_file;
    Bool have_output;

    input_file = file_info->input_file;
    output_file = file_info->output_file;
    have_output = file_info->have_output;

    if (!have_output ||
	strcmp(input_file, output_file))  /* input_file != output_file */
    {
	if (OPEN_FOR_BINARY_READING(file_info->file_in, input_file))
            CANNOT_OPEN("reading", input_file);

        if (have_output)
	{
	    if (OPEN_FOR_BINARY_WRITE_UPDATE(file_info->file_out, output_file))
		CANNOT_OPEN("reading and writing", output_file);
	}
	else
	{
	    file_info->file_out = (FILE *) NULL;
	}
    }
    else  /* have_output && (input_file == output_file) */
    {
        if (!(file_info->blocked))
        {
            sprintf(error_msg, "cannot have same input and output file");
            strcat(error_msg, " since input file not blocked");
            return  ERROR;
        }

	if (OPEN_FOR_BINARY_READ_UPDATE(file_info->file_in, input_file))
            CANNOT_OPEN("reading and writing", input_file);

        file_info->file_out = file_info->file_in;
    }

    if (have_output)
	rewind(file_info->file_out);

    return  OK;
}

void truncate_file(Size_info *size_info, String file)
{
    int ndim;
    int *npoints, *block_size;
    int nblocks[MAX_NDIM];
    long length, size_of_block, current_length;

    ndim = size_info->ndim;
    npoints = size_info->npoints;
    block_size = size_info->block_size;

    BLOCKS(nblocks, npoints, block_size, ndim);
    VECTOR_PRODUCT(length, nblocks, ndim);

    VECTOR_PRODUCT(size_of_block, block_size, ndim);
    length *= BYTES_PER_WORD * size_of_block;

    current_length = file_size(file);

/*
    printf("length=%d, current_length=%d\n", length, current_length);
*/

    if ((length != current_length) && truncate(file, length))
	printf("Error: truncating output file\n");
}
