#include "rowcol.h"

#include "utility.h"

#define  MAX_ROWS_COLS  128

static int nrows_cols;
static int nrows_cols_max = MAX_ROWS_COLS;
static int rows_cols[MAX_ROWS_COLS];

static int npts;
static int npts_alloc = 0;
static int npts_orthog = 0;
static float *data = NULL;

void free_rowcol_memory()
{
    FREE(data, float);

    npts_alloc = 0;
}

static Status alloc_rowcol_memory()
{
    if (npts > npts_alloc)
    {
	free_rowcol_memory();

/*
	MALLOC(data, float, npts);
*/
	MALLOC_ZERO(data, float, npts);

	npts_alloc = npts;
    }

    return  OK;
}

static Status find_rows_cols(String string, String error_msg)
{
    int i;
    Line msg;

    nrows_cols = get_max_integers(nrows_cols_max, rows_cols, string);

    if (nrows_cols == 0)
	RETURN_ERROR_MSG("no rows/cols given");

    for (i = 0; i < nrows_cols; i++)
    {
	sprintf(msg, "component %d of rows/columns", i+1);
	CHECK_RANGE(msg, rows_cols[i], 1, npts_orthog);
	rows_cols[i]--;
    }

    return  OK;
}

static void init_row_data(int new_add, int n, float *plane_data)
{
    int i, j;
    float *d;

    if (new_add == NEW_SLICE)
	ZERO_VECTOR(data, npts);

    for (i = 0; i < nrows_cols; i++)
    {
	j = rows_cols[i];
	d = plane_data + n*j;
	ADD_VECTORS(data, data, d, npts);
    }
}

static void init_col_data(int new_add, int n, float *plane_data)
{
    int i, j, k;

    for (k = 0; k < npts; k++, plane_data += n)
    {
	if (new_add == NEW_SLICE)
	    data[k] = 0;

	for (i = 0; i < nrows_cols; i++)
	{
	    j = rows_cols[i];
	    data[k] += plane_data[j];
	}
    }
}

Status find_rowcol_range(float *result, String range, String msg,
							String error_msg)
{
    float d;

    if (get_floats(DISPLAY_DIM, result, range) == ERROR)
    {
	sprintf(error_msg, "need lower and upper values for %s range", msg);
	return  ERROR;
    }

    d = result[1] - result[0];

    if (d <= 0)
    {
	sprintf(error_msg, "%s (upper - lower) = %7.2e, must be > 0", msg, d);
	return  ERROR;
    }

    return  OK;
}

Status initialize_rowcol(Rowcol_param *param, String error_msg)
{
    float result[DISPLAY_DIM];

    if (param->row_col == ROW_SLICE)
    {
	npts = param->npoints[0];
	npts_orthog = param->npoints[1];
    }
    else
    {
	npts = param->npoints[1];
	npts_orthog = param->npoints[0];
    }

    if (alloc_rowcol_memory() == ERROR)
	RETURN_ERROR_MSG("allocating memory for row/column");

    CHECK_STATUS(find_rows_cols(param->rows_cols, error_msg));

    if (param->row_col == ROW_SLICE)
	init_row_data(param->new_add, param->npoints[0], param->plane_data);
    else
	init_col_data(param->new_add, param->npoints[0], param->plane_data);

    param->rowcol_data = data;

    if (find_rowcol_range(result, param->point_range, "point", error_msg)
								== ERROR)
	RETURN_ERROR_MSG(error_msg);

    param->lower[0] = result[0];
    param->upper[0] = result[1];

    if (find_rowcol_range(result, param->value_range, "value", error_msg)
								== ERROR)
	RETURN_ERROR_MSG(error_msg);

    param->lower[1] = result[0];
    param->upper[1] = result[1];

    return  OK;
}
