#include "plot2.h"

#include "baseline_popup.h"
#include "callback.h"
#include "color.h"
#include "data_popup.h"
#include "display_popup.h"
#include "extract_popup.h"
#include "fit_popup.h"
#include "fold_popup.h"
#include "levels_popup.h"
#include "output_popup.h"
#include "param.h"
#include "peaks_popup.h"
#include "phase_popup.h"
#include "position.h"
#include "region_popup.h"
#include "rowcol_popup.h"
#include "slice_popup.h"
#include "track_popup.h"
#include "timer.h"
#include "window.h"

#include "script.h"
#include "command.h"

static Widget topshell;

Status region_stats_open(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status region_stats_close(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

static void quit_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    YesNo yes_no;

    de_iconify_application();
	/* if application iconfied question does not appear */

    yes_no = force_question("Do you want to save the parameters?",
						"Yes", "No", "Cancel");

    if (yes_no != CANCEL)
    {
	if (yes_no == YES)
	{
	    update_baseline_params();
	    update_data_params();
	    update_display_params();
	    update_extract_params();
	    update_fit_params();
	    update_fold_params();
	    update_levels_params();
	    update_object_params();
	    update_output_params();
	    update_peaks_params();
	    update_phase_params();
	    update_property_params();
	    update_region_params();
	    update_rowcol_params();
	    update_slice_params();
	    update_tracking_params();
    	    save_parameters();

	    save_positions();
	}

	exit(0);
    }
}

static void displays_popup_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    display_popup_callback(widget, data, cbs);
    slice_popup_callback(widget, data, cbs);
    tracking_popup_callback(widget, data, cbs);
}

static void check_early_exit(Widget widget)
{
    if (!widget)
	ERROR_AND_EXIT("could not even create toplevel module");
}

void main(int argc, char **argv)
{
    int nbuttons;
    Line error_msg;
    Widget form, top, bottom, middle;
    Button_item top_items[] =
    {
	{ "extract",	extract_popup_callback,		NO_DATA },
	{ "region",	region_popup_callback,		NO_DATA },
	{ "levels",	levels_popup_callback,		NO_DATA }
    };
    Button_item middle_items[] =
    {
	{ "data",	data_popup_callback,		NO_DATA },
	{ "displays",	displays_popup_callback,	NO_DATA },
	{ "slices",	rowcol_popup_callback,		NO_DATA }
    };
    Button_item bottom_items[] =
    {
	{ "output",	output_popup_callback,		NO_DATA },
	{ "quit",	quit_callback,			NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) plot2_help }
    };

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    topshell = initialize_application("Plot2", &argc, argv);
    check_early_exit(topshell);

    register_shell(topshell);

    initialize_parameters(argv[0]);
    initialize_colors();
    read_positions();

    form = create_form(topshell);
    check_early_exit(form);

    nbuttons = ARRAY_SIZE(top_items);
    top = create_horizontal_buttons(form, top_items, nbuttons);
    check_early_exit(top);
    attachments(top, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(top, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    nbuttons = ARRAY_SIZE(middle_items);
    middle = create_horizontal_buttons(form, middle_items, nbuttons);
    check_early_exit(middle);
    attachments(middle, top, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(middle, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    nbuttons = ARRAY_SIZE(bottom_items);
    bottom = create_horizontal_buttons(form, bottom_items, nbuttons);
    check_early_exit(bottom);
    attachments(bottom, middle, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(bottom, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(form);

    change_delete_protocol(topshell, quit_callback);

    if (argc > 1)
    {
	set_screen_timer();

	if (run_script_file(argv[1], script_action_table, error_msg) == ERROR)
	    ERROR_AND_EXIT(error_msg);

	set_normal_timer();

	printf("Finished running plot2 file\n");
    }

    application_main_loop();
}
