#include "phase_func.h"

#include "object.h"  /* for VISIBILITY_ON/OFF */
#include "param.h"
#include "phase.h"
#include "slice.h"

static int phase_on_off_type = VISIBILITY_ON;

static Bool have_valid_phasing = FALSE;

#define  SET_VALUE(string, value) \
	 {   sprintf(string, "%7.2f", value);   }

#define  SET_VALUE_OR_DEFAULT(string, value) \
	 {   if (!(*(string)))  SET_VALUE(string, value);   }

#define  PHASE_PIVOT	1.0

#define  PHASE0_MIN	-180.0
#define  PHASE0_MAX	180.0
#define  PHASE0_VALUE	0.0
#define  PHASE1_MIN	-360.0
#define  PHASE1_MAX	360.0
#define  PHASE1_VALUE	0.0

void set_phase_params()
{
/*  below done so that sensible default used  */
    SET_VALUE_OR_DEFAULT(phase_pivot, PHASE_PIVOT);

/*  below needed so that scale initialized correctly  */
    SET_VALUE_OR_DEFAULT(phase0_min, PHASE0_MIN);
    SET_VALUE_OR_DEFAULT(phase0_max, PHASE0_MAX);
    SET_VALUE_OR_DEFAULT(phase0_value, PHASE0_VALUE);
    SET_VALUE_OR_DEFAULT(phase1_min, PHASE1_MIN);
    SET_VALUE_OR_DEFAULT(phase1_max, PHASE1_MAX);
    SET_VALUE_OR_DEFAULT(phase1_value, PHASE1_VALUE);
}

static void update_phase_data()
{
    if (*phase_on_off)
	phase_on_off_type = atoi(phase_on_off);

    set_phase_params();
}

void default_phase_numbers()
{
    SET_VALUE(phase0_min, PHASE0_MIN);
    SET_VALUE(phase0_max, PHASE0_MAX);
    SET_VALUE(phase0_value, PHASE0_VALUE);
    SET_VALUE(phase1_min, PHASE1_MIN);
    SET_VALUE(phase1_max, PHASE1_MAX);
    SET_VALUE(phase1_value, PHASE1_VALUE);
}

static void update_phasing()
{
    Phase_info phase_info;

    phase_info.pivot = atof(phase_pivot);
    phase_info.phase0 = atof(phase0_value);
    phase_info.phase1 = atof(phase1_value);

    do_phasing(&phase_info);
}

Status phase_apply_func(Slice_info *info, String error_msg)
{
    update_phase_data();

    if (phase_on_off_type == VISIBILITY_OFF)
    {
	have_valid_phasing = TRUE;
	return  OK;
    }

    have_valid_phasing = FALSE;

    CHECK_STATUS(initialize_phase(info->npoints, &(info->data), error_msg));

    update_phasing();
    have_valid_phasing = TRUE;

    return  OK;
}

void phase_scale_func()
{
    if (have_valid_phasing && (phase_on_off_type == VISIBILITY_ON))
	update_phasing();
}
