#include "peaks_popup.h"

#include "peaks.hlp"

#include "callback.h"
#include "data.h"
#include "display_popup.h"
#include "fit_popup.h"
#include "info_popup.h"
#include "param.h"
#include "peak.h"
#include "peak_popup.h"
#include "peaks_func.h"
#include "ref.h"
#include "region_func.h"
#include "utility.h"
#include "window.h"

#define  VISIBLE_ITEMS  30

static Widget peaks_popup = (Widget) NULL;
static Widget peaks_form;

static Widget file_field;

static Textfield_item texts_items[] =
{
    { "peaks file: ", peaks_file, NO_CALLBACK, NO_DATA, &file_field }
};

static int ntexts = ARRAY_SIZE(texts_items);

static Widget peak_list;

void update_peaks_params()
{
    if (peaks_popup)
	get_textfields(texts_items, ntexts);
}

static Status select_command(int npeaks_selected, int *peaks_selected,
							String error_msg)
{
    peak_select_func(npeaks_selected, peaks_selected);

    return  OK;
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
/*
    int peak = list_position(cbs);
*/
    int i, npeaks_selected, *peaks_selected;
    Line error_msg;

    if (selection_from_list(widget, &peaks_selected, &npeaks_selected))
    {
	for (i = 0; i < npeaks_selected; i++)
	    peaks_selected[i]--;
    }
    else
    {
	npeaks_selected = 0;
	peaks_selected = (int *) NULL;
    }

    if (select_command(npeaks_selected, peaks_selected, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status peaks_select_command(String value, Generic_ptr data, String error_msg)
{
    int peak, *peaks;

    if (!peak_name_exists(value, &peak))
    {
	sprintf(error_msg, "peak '%s' unknown", value);
	return  ERROR;
    }

    sprintf(error_msg, "allocating memory for peak");
    MALLOC(peaks, int, 1);
    peaks[0] = peak;

    CHECK_STATUS(select_command(1, peaks, error_msg));

    return  OK;
}

static Status add_new_peak(Peak *peak, String error_msg)
{
    Line entry;

    sprintf(entry, "%s: %s (%d, %d) %3.2e", peak->peak_set->set, peak->name, peak->x, peak->y, peak->extremum);

    insert_in_list(peak_list, entry, 0);

    new_peak_set();

    return  OK;
}

Status check_add_peak(String error_msg)
{
    /* only one request at a time, otherwise things get confused */
    /* really want to make peak dialog modal but not sure how */
    static Bool have_request = FALSE;
    static int ref_type = REF_POINTS;
    int size[DISPLAY_DIM], begin[DISPLAY_DIM], end[DISPLAY_DIM];
    Line set, x_range, y_range;
    Bool answer;

    if (have_request)
    {
	add_peak_popup();

	return  OK;
    }

    have_request = TRUE;

    *set = 0;

    if (rectangle_displayed(size, begin, end))
    {
	CHECK_STATUS(find_box_region(&ref_type, x_range, y_range, size, begin, end, error_msg));
    }
    else
    {
	*x_range = 0;
	*y_range = 0;
    }

    answer = add_peak_dialog(set, &ref_type, x_range, y_range);

    have_request = FALSE;

    if (answer)
	CHECK_STATUS(add_peak_func(set, ref_type, x_range, y_range, add_new_peak, error_msg));

    return  OK;
}

static void add_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (check_add_peak(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static Status delete_command(String error_msg)
{
    int i, npeaks_deleted;
    int *peaks_deleted;

    CHECK_STATUS(peak_delete_func(&npeaks_deleted, &peaks_deleted, error_msg));

    if (peak_list)
    {
/*
	delete_from_list(peak_list, peak+1);
*/
	for (i = npeaks_deleted-1; i >= 0; i--)
	    delete_from_list(peak_list, peaks_deleted[i]+1);
    }

    FREE(peaks_deleted, int);

    update_peak_set_list();

    return  OK;
}

static void delete_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    (void) delete_command(error_msg); /* do not care about 'ERROR' */
}

Status peaks_delete_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(delete_command(error_msg));

    return  OK;
}

static Status stretch_peaks(String error_msg)
{
    static int ref_type = REF_POINTS;
    int size[DISPLAY_DIM], begin[DISPLAY_DIM], end[DISPLAY_DIM];
    Line x_range, y_range;

    if (!rectangle_displayed(size, begin, end))
	RETURN_ERROR_MSG("must have region (box) selected");

    CHECK_STATUS(find_box_region(&ref_type, x_range, y_range, size, begin, end, error_msg));
 
    if (ref_type != REF_PPM)
	RETURN_ERROR_MSG("region must be in ppm");

    CHECK_STATUS(stretch_peak_func(ref_type, x_range, y_range, error_msg));

    do_display_drawing();

    return  OK;
}

static void stretch_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (stretch_peaks(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static void normal_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    reset_data_scale_offset();

    do_display_drawing();
}

static Status load_command(String error_msg)
{
    CHECK_STATUS(peaks_load_func(add_new_peak, error_msg));

    return  OK;
}

static void load_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_peaks_params();

    if (load_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status peaks_load_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(load_command(error_msg));

    return  OK;
}

static Status save_command(String error_msg)
{
    CHECK_STATUS(peaks_save_func(error_msg));

    return  OK;
}

static void save_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_peaks_params();

    if (save_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status peaks_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(save_command(error_msg));

    return  OK;
}

static void fit_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
/*
    fit_popup_callback(peaks_form, (Callback_ptr) NULL,
    fit_popup_callback(widget, (Callback_ptr) NULL,
*/
    fit_popup_callback(get_topshell(), (Callback_ptr) NULL,
						(Callback_ptr) NULL); 
}

static Widget create_peak_list_form(Widget parent)
{
    Scrolled_list_info peak_list_info;
    Widget label, buttons, form;
    static Button_item button_items[] =
    {
	{ "add",	add_callback,		NULL },
	{ "delete",	delete_callback,	NULL },
	{ "stretch",	stretch_callback,	NULL },
	{ "normal",	normal_callback,	NULL }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    form = create_form(parent);
    CHECK_WIDGET(form);

    label = create_label(form, "peaks:");
    CHECK_WIDGET_DESTROY(label, form);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    buttons = create_vertical_buttons(form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY(buttons, form);
    attachments(buttons, label, NO_ATTACH, FORM_ATTACH, NO_ATTACH);
    offsets(buttons, 2*UNIT_OFFSET, NO_OFFSET, 2*UNIT_OFFSET, NO_OFFSET);

    peak_list_info.selection_policy = EXTENDED_SELECT;
    peak_list_info.nitems = 0;
    peak_list_info.nvisible_items = VISIBLE_ITEMS;
    peak_list_info.callback = select_callback;

    peak_list = create_scrolled_list(form, &peak_list_info);
    CHECK_WIDGET_DESTROY(peak_list, form);
    attachments(WIDGET_PARENT(peak_list),
				label, FORM_ATTACH, buttons, FORM_ATTACH);
    offsets(WIDGET_PARENT(peak_list),
			UNIT_OFFSET, UNIT_OFFSET, 2*UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(form);

    return  form;
}

static void create_peaks_popup(Widget parent)
{
    Widget buttons, form, texts;
    static Button_item button_items[] =
    {
    	{ "load",	load_callback,		NO_DATA },
    	{ "save",	save_callback,		NO_DATA },
    	{ "fit",	fit_callback,		NO_DATA },
#define  DISMISS_BUTTON  3
    	{ "dismiss",	dismiss_callback,	NO_DATA },
    	{ "help",	help_callback,		(Callback_ptr) peaks_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    peaks_popup = create_popup(parent, "Plane Peaks");
    CHECK_WIDGET_WARNING(peaks_popup);

    peaks_form = create_form(peaks_popup);
    CHECK_WIDGET_DESTROY_WARNING(peaks_form, peaks_popup);

    form = create_peak_list_form(peaks_form);
    CHECK_WIDGET_DESTROY_WARNING(form, peaks_popup);
    attachments(form, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(peaks_form, texts_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, peaks_popup);
    attachments(texts, form, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) peaks_form;
    buttons = create_horizontal_buttons(peaks_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, peaks_popup);
    attachments(buttons, texts, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    manage_widget(peaks_form);
}

void peaks_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!peaks_popup)
        create_peaks_popup(parent);

    if (peaks_popup)
        popup(peaks_form);
}

Status peaks_popup_command(String value, Generic_ptr data, String error_msg)
{
    peaks_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
