#ifndef _incl_peak
#define _incl_peak

#include "macros.h"
#include "types.h"

struct Peak;

typedef struct
{
    String set;
    int method;
    float param1;
    float param2;
    float param3;
    float chisq;
    int nalloc;
    int npeaks;
    struct Peak **peaks;
}   Peak_set;

typedef struct Peak
{
    String name;
    int x;
    float x_ppm;
    int y;
    float y_ppm;
    float extremum;
    Bool have_fit;
    float param;
    float fit_extremum;
    Peak_set *peak_set;
}   Peak;

typedef Status (*Add_peak_func)(Peak *peak, String error_msg);

extern Status add_peak
	(String set, String name, int x, float x_ppm,
	 int y, float y_ppm, float extremum,
	 Add_peak_func add_func, String error_msg);

extern void delete_peak
	(int peak);

Bool peak_name_exists
	(String name, int *peak);

extern int find_peak_set
	(String set);

extern Peak_set **get_peak_sets
	(int *p_npeak_sets);

extern Peak **get_peaks
	(int *p_npeaks);

#endif /* _incl_peak */
