#include "output_func.h"

#include "baseline_func.h"
#include "data.h"
#include "date.h"
#include "draw.h"
#include "hpgl.h"
#include "levels_func.h"
#include "object.h"
#include "object_func.h"
#include "output.h"
#include "param.h"
#include "phase_func.h"
#include "ps.h"
#include "region_func.h"
#include "rowcol_func.h"
#include "slice.h"
#include "utility.h"

#define  OUTPUT_FONT	"Times-Roman"

static int display_type = TWO_DISPLAY;
static int time_date_type = TIME_DATE;
static int file_name_type = FILE_NAME;
static int size_mode_type = SIZE_PICTURE;
static int size_units_type = SIZE_PICTURE;
static int paper_size_type = A4_PAPER;
static int paper_dirn_type = PORTRAIT;
static int output_color_type = BLACK_WHITE;
static int output_gl_type = PS_OUTPUT;

static void update_output_data()
{
    if (*display_mode)
	display_type = atoi(display_mode);

    if (*time_date)
	time_date_type = atoi(time_date);

    if (*show_name)
	file_name_type = atoi(show_name);

    if (*size_mode)
	size_mode_type = atoi(size_mode);

    if (*size_units)
	size_units_type = atoi(size_units);

    if (*paper_size)
	paper_size_type = atoi(paper_size);

    if (*paper_dirn)
	paper_dirn_type = atoi(paper_dirn);

    if (*output_color)
	output_color_type = atoi(output_color);

    if (*output_gl)
	output_gl_type = atoi(output_gl);
}

Status output_save_func(String error_msg)
{
    int ndata_sets;
    Draw_info draw_info;
    Data_info *data_info;
    Global_info global_info;
    Slice_info slice_info;
    Draw_funcs *ptr_draw_funcs;
    Status status;
    static Line time_and_date, fonts;
    static Timer_funcs no_timer_funcs =
                { start_no_timer, update_no_timer, stop_no_timer };
    static FILE *fp;
    static float size[PLOT_DIM];
    static Output_param output_param = { output_size, size };
    static Output_border title = { output_title, OUTPUT_FONT, 18,
				JUSTIFICATION_LEFT, EDGE_TOP, TRUE };
    static Output_border date = { time_and_date, OUTPUT_FONT, 12,
				JUSTIFICATION_RIGHT, EDGE_BOTTOM, TRUE };
    static Output_border file = { output_file, OUTPUT_FONT, 12,
				JUSTIFICATION_LEFT, EDGE_BOTTOM, TRUE };
    static Output_choices choices = { &title, &date, &file, size, other_size,
				A4_PAPER, PORTRAIT, BLACK_WHITE, TRUE };
    static Output_setup output_setup = { SIZE_PICTURE, INCH_UNITS,
							PS_OUTPUT, &choices };
    static Ps_data ps_data = { (FILE *) NULL, PS_OUTPUT, &choices, fonts };
    static Draw_funcs ps_draw_funcs = { PAPER_DISPLAY, (Generic_ptr) &ps_data,
	start_ps, end_ps, new_ps_range, ps_line, ps_text,
	set_ps_color, set_ps_font, set_ps_line_style };
    static Hpgl_data hpgl_data = { (FILE *) NULL, &choices };
    static Draw_funcs hpgl_draw_funcs = { PAPER_DISPLAY,
	(Generic_ptr) &hpgl_data,
	start_hpgl, end_hpgl, new_hpgl_range, hpgl_line,
	hpgl_text, set_hpgl_color, set_hpgl_font, set_hpgl_line_style };

    update_output_data();

#ifdef USE_XPM
    if (output_gl_type == XPM_OUTPUT)
	return  OK;
#endif /* USE_XPM */

    strcpy(fonts, OUTPUT_FONT);

    STRIP_LEADING_SPACE(output_file);
    STRIP_TRAILING_SPACE(output_file);

    CHECK_STATUS(get_output_param(&output_param, error_msg));

    get_time_and_date(time_and_date);

    if (display_type == TWO_DISPLAY)
    {
	if (levels_apply_func(&(draw_info.nlevels), &(draw_info.levels),
							error_msg) == ERROR)
	    RETURN_ERROR_MSG(error_msg);

	if (region_apply_func(&(draw_info.ref_type), draw_info.lower,
			draw_info.upper, draw_info.fold_type,
			draw_info.flip_type, error_msg) == ERROR)
	    RETURN_ERROR_MSG(error_msg);

	if (objects_apply_func(&(draw_info.ndata_sets), &(draw_info.data_info),
				&(draw_info.global_info), error_msg) == ERROR)
	    RETURN_ERROR_MSG(error_msg);
    }
    else /* display_type == ONE_DISPLAY */
    {
	if (objects_apply_func(&ndata_sets, &data_info, &global_info, error_msg)
                                                                == ERROR)
	    RETURN_ERROR_MSG(error_msg);

	if (rowcol_apply_func(&slice_info, data_info, error_msg) == ERROR)
	    RETURN_ERROR_MSG(error_msg);

	if (phase_apply_func(&slice_info, error_msg) == ERROR)
	    RETURN_ERROR_MSG(error_msg);

	if (baseline_apply_func(&slice_info, error_msg) == ERROR)
	    RETURN_ERROR_MSG(error_msg);

        COPY_VECTOR(slice_info.major_ticks, global_info.major_ticks, DISPLAY_DIM);
	COPY_VECTOR(slice_info.minor_ticks, global_info.minor_ticks, DISPLAY_DIM);
    }

    if ((fp = fopen(output_file, WRITE)) == NULL)
    {
	sprintf(error_msg, "opening file '%s' for writing", output_file);
	return  ERROR;
    }

    choices.paper_size = paper_size_type;
    choices.paper_dirn = paper_dirn_type;
    choices.output_color = output_color_type;

    if (time_date_type == TIME_DATE)
	choices.time_date->use = TRUE;
    else
	choices.time_date->use = FALSE;

    if (file_name_type == FILE_NAME)
	choices.file_name->use = TRUE;
    else
	choices.file_name->use = FALSE;

    output_setup.size_mode = size_mode_type;
    output_setup.size_units = size_units_type;
    output_setup.output_gl = output_gl_type;

    if (setup_output(&output_setup, error_msg) == ERROR)
    {
	fclose(fp);
	RETURN_ERROR_MSG(error_msg);
    }

    if ((output_gl_type == PS_OUTPUT) || (output_gl_type == EPS_OUTPUT))
    {
        ptr_draw_funcs = &ps_draw_funcs;

        ps_data.file = fp;
        ps_data.type = output_gl_type;
    }
    else /* output_gl_type == HPGL_OUTPUT */
    {
        ptr_draw_funcs = &hpgl_draw_funcs;

        hpgl_data.file = fp;
    }

    if (display_type == TWO_DISPLAY)
    {
	if ((status = do_drawing(&draw_info, ptr_draw_funcs,
					&no_timer_funcs, error_msg)) != OK)
	{
	    fclose(fp);

	    return  status;
	}
    }
    else /* display_type == ONE_DISPLAY */
    {
	do_slice(ptr_draw_funcs, &slice_info);
    }

    fclose(fp);

    return  OK;
}
