#include "object_func.h"

#include "color.h"
#include "data.h"
#include "object.h"
#include "param.h"
#include "style.h"
#include "ticks.h"

#define  DEFAULT_MAJOR_TICKS	5
#define  DEFAULT_MINOR_TICKS	20

static int visibility_type = VISIBILITY_ON;

typedef struct
{
    String visible;
    String color;
}   Object_strings;

/* background always visible so do not bother saving */
static Param_value background_visible = "";

static Object_strings global_strings[] =
{
    {  pos_visible,	pos_color  },
    {  neg_visible,	neg_color  },
    {  col_visible,	col_color  },
    {  row_visible,	row_color  },
    {  cross_visible,	cross_color  },
    {  grid_visible,	grid_color  },
    {  ruler_visible,	ruler_color  },
    {  background_visible,	background_color  }
};

static Object_property global_properties[NGLOBAL_OBJECTS];

static int object_selected[NGLOBAL_OBJECTS];

static String default_colors[] =
{
    "Black", "Red", "Blue", "Blue", "Green", "Green", "Green", "White"
};

#define  DEFAULT_SCALE  1.0

static void update_object_data()
{
    int i;
    static Bool first_pass = TRUE;

    if (first_pass)
    {
	first_pass = FALSE;

	for (i = 0; i < NGLOBAL_OBJECTS; i++)
	{
	    if (*(global_strings[i].color))
	    {
	    	global_properties[i].color =
				get_color_index(global_strings[i].color);
	    }
	    else
	    {
	    	global_properties[i].color =
				get_color_index(default_colors[i]);
	    }

	    if (*(global_strings[i].visible))
	    {
	    	global_properties[i].visible = atoi(global_strings[i].visible);
	    }
	    else
	    {
	    	global_properties[i].visible = VISIBILITY_ON;
	    }
	}
    }

    if (!(*major_ticks))
	sprintf(major_ticks, "%d", DEFAULT_MAJOR_TICKS);

    if (!(*minor_ticks))
	sprintf(minor_ticks, "%d", DEFAULT_MINOR_TICKS);

    if (*default_visible)
	visibility_type = atoi(default_visible);
}

void default_property(Object_property *property)
{
    int i;

    update_object_data();

    for (i = 0; i < NDATA_OBJECTS; i++)
    {
	property[i].visible = VISIBILITY_ON;
	property[i].color = global_properties[i].color;
	property[i].scale = DEFAULT_SCALE;
	property[i].line_style = NORMAL_LINE_STYLE;
    }

    property[NEGATIVE_OBJECT].line_style = DASHED_LINE_STYLE;
}

Status objects_apply_func(int *ndata_sets, Data_info **data_info,
				Global_info *global_info, String error_msg)
{
    update_object_data();

    find_ticks(major_ticks, global_info->major_ticks);
    find_ticks(minor_ticks, global_info->minor_ticks);

    global_info->property = global_properties;
    
    return  get_data_info(ndata_sets, data_info, error_msg);
}

static void get_object_info()
{
    int object;

    for (object = 0; object < NGLOBAL_OBJECTS; object++)
    {
	if (object_selected[object])
	    break;
    }

    if (object < NGLOBAL_OBJECTS)
    {
	strcpy(default_color, get_color_name(global_properties[object].color));
	sprintf(default_visible, "%d", global_properties[object].visible);
    }
}

static void set_object_info()
{
    int color, object;

    update_object_data();

    color = get_color_index(default_color);

    for (object = 0; object < NGLOBAL_OBJECTS; object++)
    {
	if (object_selected[object])
	{
	    global_properties[object].color = color;
	    strcpy(global_strings[object].color, default_color);

	    global_properties[object].visible = visibility_type;
	    sprintf(global_strings[object].visible, "%d", visibility_type);
	}
    }
}

static void check_init_object_selected()
{
    int i;
    static Bool first_pass = TRUE;

    if (first_pass)
    {
	for (i = 0; i < NGLOBAL_OBJECTS; i++)
	    object_selected[i] = FALSE;

	first_pass = FALSE;
    }
}

void object_object_func(int object)
{
    check_init_object_selected();

    object_selected[object] = !object_selected[object];
}

void object_get_func()
{
    check_init_object_selected();

    get_object_info();
}

void object_set_func()
{
    check_init_object_selected();

    set_object_info();
}

int object_objects_set()
{
    int i, n = 0;

    check_init_object_selected();

    for (i = (NGLOBAL_OBJECTS-1); i >= 0; i--)
    {
        n *= 2;

        if (object_selected[i])
            n++;
    }

    return  n;
}
