#ifndef _incl_object
#define _incl_object

#include "macros.h"
#include "types.h"
#include "consts.h"

#define  POSITIVE_OBJECT	0
#define  NEGATIVE_OBJECT	1
#define  COLUMN_OBJECT		2
#define  ROW_OBJECT		3
#define  CROSSHAIR_OBJECT	4
#define  GRID_OBJECT		5
#define  RULER_OBJECT		6
#define  BACKGROUND_OBJECT	7

#define  NDATA_OBJECTS		4
#define  NGLOBAL_OBJECTS	8

static String object_labels[] =
{
    "positive contours",	"negative contours",
    "column slices",		"row slices",
    "crosshair",		"grid",
    "ruler",			"background"
};

#define  VISIBILITY_ON		0
#define  VISIBILITY_OFF		1

typedef struct
{
    int visible;
    int color;
    float scale;
    int line_style;
}   Object_property;

typedef struct
{
    int major_ticks[DISPLAY_DIM];
    int minor_ticks[DISPLAY_DIM];
    Object_property *property;
}   Global_info;

extern Bool object_name_exists
	(int n, String name, int *p_object);

#endif /* _incl_object */
