#include "levels_popup.h"

#include "levels.hlp"

#include "callback.h"
#include "display_popup.h"
#include "levels.h"
#include "param.h"
#include "window.h"

static Widget levels_popup = (Widget) NULL;
static Widget levels_form;

static Widget base_field;
static Widget number_field;
static Widget change_field;
static Widget modify_field;

static Textfield_item textfield_items1[] =
{
    { "base level: ", base_level, NO_CALLBACK, NO_DATA, &base_field },
    { "number of levels: ", number_levels, NO_CALLBACK, NO_DATA,&number_field },
    { "change between levels: ", change_levels, NO_CALLBACK, NO_DATA,
								&change_field }
};

static int ntexts1 = ARRAY_SIZE(textfield_items1);

static Textfield_item textfield_items2[] =
{
    { "base level modifier: ", level_modifier, NO_CALLBACK, NO_DATA,
							&modify_field }
};

static int ntexts2 = ARRAY_SIZE(textfield_items2);

#define  NCHANGE_TYPES  2

static Widget change_boxes[NCHANGE_TYPES];
static Radiobox_item change_items[] =
{
    { "multiplicative", NO_CALLBACK, NO_DATA, change_boxes + CHANGE_MULTIPLY },
    { "additive", NO_CALLBACK, NO_DATA, change_boxes + CHANGE_ADD },
};

static int change_type = CHANGE_MULTIPLY;
static int nchange_types = ARRAY_SIZE(change_boxes);

#define  NTIMER_TYPES  2

static Widget timer_boxes[NTIMER_TYPES];
static Radiobox_item timer_items[] =
{
    { "timer on", NO_CALLBACK, NO_DATA, timer_boxes + TIMER_ON },
    { "timer off", NO_CALLBACK, NO_DATA, timer_boxes + TIMER_OFF },
};

static int timer_type = TIMER_ON;
static int ntimer_types = ARRAY_SIZE(timer_boxes);

void update_levels_params()
{
    if (levels_popup)
    {
	get_textfields(textfield_items1, ntexts1);
	get_textfields(textfield_items2, ntexts2);
    	change_type = get_radio_state(change_boxes, nchange_types);
    	timer_type = get_radio_state(timer_boxes, ntimer_types);

	sprintf(change_mode, "%d", change_type);
	sprintf(timer_mode, "%d", timer_type);
    }
    else
    {
	if (*change_mode)
	    change_type = atoi(change_mode);

	if (*timer_mode)
	    timer_type = atoi(timer_mode);
    }
}

Status levels_apply(int *nlevels, float **levels, String error_msg)
{
    update_levels_params();

    CHECK_STATUS(levels_apply_func(nlevels, levels, error_msg));

    return  OK;
}

static void apply_command()
{
    do_display_drawing();
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    apply_command();
}

Status levels_apply_command(String value, Generic_ptr data, String error_msg)
{
    apply_command();

    return  OK;
}

static Status action_command(int modify_type, String error_msg)
{
    CHECK_STATUS(levels_action_func(modify_type, error_msg));

    if (levels_popup)
	set_textfields(textfield_items1, 1);

    do_display_drawing();

    return  OK;
}

static void action_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_levels_params();

    if (action_command((int) data, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status levels_multiply_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(action_command(MODIFY_MULTIPLY, error_msg));

    return  OK;
}

Status levels_divide_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(action_command(MODIFY_DIVIDE, error_msg));

    return  OK;
}

Status levels_add_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(action_command(MODIFY_ADD, error_msg));

    return  OK;
}

Status levels_subtract_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(action_command(MODIFY_SUBTRACT, error_msg));

    return  OK;
}

static void create_levels_popup(Widget parent)
{
    Widget buttons, radio, texts, separator;
    static Button_item button_items[] =
    {
    	{ " * ",	action_callback,	(Callback_ptr) MODIFY_MULTIPLY},
    	{ " / ",	action_callback,	(Callback_ptr) MODIFY_DIVIDE },
    	{ " + ",	action_callback,	(Callback_ptr) MODIFY_ADD },
    	{ " - ",	action_callback,	(Callback_ptr) MODIFY_SUBTRACT }
    };
    static int nbuttons = ARRAY_SIZE(button_items);
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "apply";

    update_levels_params();

    levels_popup = create_popup(parent, "Contour Levels");
    CHECK_WIDGET_WARNING(levels_popup);

    levels_form = create_form(levels_popup);
    CHECK_WIDGET_DESTROY_WARNING(levels_form, levels_popup);

    texts = create_textfields(levels_form, textfield_items1, ntexts1);
    CHECK_WIDGET_DESTROY_WARNING(texts, levels_popup);
    attachments(texts, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(levels_form, change_items, nchange_types,
						change_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, levels_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(levels_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, levels_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(levels_form, textfield_items2, ntexts2);
    CHECK_WIDGET_DESTROY_WARNING(texts, levels_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    buttons = create_horizontal_buttons(levels_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, levels_popup);
    attachments(buttons, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);
    offsets(buttons, NO_OFFSET, NO_OFFSET, NO_OFFSET, UNIT_OFFSET);

    separator = create_separator(levels_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, levels_popup);
    attachments(separator, buttons, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, NO_OFFSET, NO_OFFSET, NO_OFFSET);

    radio = create_radiobox(levels_form, timer_items, ntimer_types,
						timer_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, levels_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    separator = create_separator(levels_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, levels_popup);
    attachments(separator, radio, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, NO_OFFSET, NO_OFFSET, NO_OFFSET);

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = apply_callback;
    adh_info.dismiss_form = levels_form;
    adh_info.help_message = levels_help;

    buttons = create_apply_dismiss_help(levels_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, levels_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    manage_widget(levels_form);
}

void levels_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!levels_popup)
        create_levels_popup(parent);

    if (levels_popup)
        popup(levels_form);
}

Status levels_popup_command(String value, Generic_ptr data, String error_msg)
{
    levels_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
