#ifndef _incl_fit
#define _incl_fit

#include "macros.h"
#include "types.h"

static String fit_methods[] =
{
#define  NO_FIT			0
	"no fit",

#define  LINEAR_FIT		1
	"Ax + B",

#define  LOG_LINEAR_FIT		2
	"log (A exp(-Bx))",

#define  NONLINEAR2_FIT		3
	"A exp(-Bx)",

#define  NONLINEAR3_FIT		4
	"A exp(-Bx) + C",

#define  NFIT_METHODS		5
	""
};

extern Status fit_data
	(int method, int ndata, float *x, float *y,
	 float *params_fit, float *y_fit, float *chisq, String error_msg);

extern int get_method_nparams
	(int method);

extern float calculate_fit
	(int method, float x, float *params_fit);

#endif /* _incl_fit */
