#include "command.h"

#include "baseline_func.h"
#include "data_func.h"
#include "extract_func.h"
#include "fit_func.h"
#include "levels_func.h"
#include "object_func.h"
#include "output_func.h"
#include "peaks_func.h"
#include "phase_func.h"
#include "prop_func.h"
#include "region_func.h"
#include "rowcol_func.h"
#include "save_func.h"
#include "script.h"

#include "data.h"
#include "levels.h"
#include "object.h"
#include "peak.h"
#include "position.h"
#include "utility.h"

static Timer_funcs timer_funcs = { start_screen_timer, update_screen_timer,
							stop_screen_timer };
static Print_funcs print_funcs = { start_screen_print, print_screen_message,
							end_screen_print };

void print_error_message(String message)
{
    fprintf(stderr, message);
}

Status baseline_half_width_next_command(String value, Generic_ptr data,
							String error_msg)
{
    baseline_half_width_next_func();

    return  OK;
}

Status baseline_degree_order_next_command(String value, Generic_ptr data,
							String error_msg)
{
    baseline_degree_order_next_func();

    return  OK;
}

Status baseline_half_width_previous_command(String value, Generic_ptr data,
							String error_msg)
{
    baseline_half_width_previous_func();

    return  OK;
}

Status baseline_degree_order_previous_command(String value, Generic_ptr data,
							String error_msg)
{
    baseline_degree_order_previous_func();

    return  OK;
}

Status baseline_apply_command (String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status baseline_load_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(baseline_load_func(error_msg));

    return  OK;
}

Status baseline_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(baseline_save_func(error_msg));

    return  OK;
}

Status baseline_clear_command(String value, Generic_ptr data, String error_msg)
{
    baseline_clear_func();

    return  OK;
}

Status baseline_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status data_delete_command(String value, Generic_ptr data, String error_msg)
{
    data_delete_func();

    return  OK;
}

Status data_next_command(String value, Generic_ptr data, String error_msg)
{
    data_next_func();

    return  OK;
}

Status data_previous_command(String value, Generic_ptr data, String error_msg)
{
    data_previous_func();

    return  OK;
}

Status data_select_command(String value, Generic_ptr data, String error_msg)
{
    int data_set;

    if (!data_name_exists(value, &data_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    data_select_func(data_set);

    return  OK;
}

Status data_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status data_all_on_command(String value, Generic_ptr data, String error_msg)
{
    data_all_on_func();

    return  OK;
}

Status data_all_off_command(String value, Generic_ptr data, String error_msg)
{
    data_all_off_func();

    return  OK;
}

Status data_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status display_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status extract_load_command(String value, Generic_ptr data, String error_msg)
{
    int data_set;
    Status status;

    if ((status = extract_load_func(&data_set, &timer_funcs, yes_func,
                                                        error_msg)) != OK)
    {
        remove_data_set_func(data_set);
        remove_property_set_func(data_set);
        remove_rowcol_set_func(data_set);
        remove_save_set_func(data_set);

        return  status;
    }

    return  OK;
}

Status extract_run_command(String value, Generic_ptr data, String error_msg)
{
    return run_script_file(value, script_action_table, error_msg);
}

Status extract_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status fit_select_command(String value, Generic_ptr data, String error_msg)
{
    int peak_set;

    if ((peak_set = find_peak_set(value)) < 0)
    {
        sprintf(error_msg, "peak set '%s' unknown", value);
        return  ERROR;
    }

    fit_select_set_func(&peak_set);

    return  OK;
} 

Status fit_next_command(String value, Generic_ptr data, String error_msg)
{
    int peak_set;

    fit_next_set_func(&peak_set);

    return  OK;
} 

 
Status fit_previous_command(String value, Generic_ptr data, String error_msg)
{
    int peak_set;

    fit_next_set_func(&peak_set);

    return  OK;
} 

 
Status fit_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
} 

Status fold_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status fold_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status levels_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status levels_multiply_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(levels_action_func(MODIFY_MULTIPLY, error_msg));

    return  OK;
}

Status levels_divide_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(levels_action_func(MODIFY_DIVIDE, error_msg));

    return  OK;
}

Status levels_add_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(levels_action_func(MODIFY_ADD, error_msg));

    return  OK;
}

Status levels_subtract_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(levels_action_func(MODIFY_SUBTRACT, error_msg));

    return  OK;
}

Status levels_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status object_object_command(String value, Generic_ptr data, String error_msg)
{
    int object;

    if (!object_name_exists(NGLOBAL_OBJECTS, value, &object))
    {
	sprintf(error_msg, "object name '%s' unknown", value);
	return  ERROR;
    }

    object_object_func(object);

    return  OK;
}

Status object_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status object_get_command(String value, Generic_ptr data, String error_msg)
{
    object_get_func();

    return  OK;
}

Status object_set_command(String value, Generic_ptr data, String error_msg)
{
    object_set_func();

    return  OK;
}

Status object_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status output_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(output_save_func(error_msg));

    return  OK;
}

Status output_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status peaks_select_command(String value, Generic_ptr data, String error_msg)
{
    int peak, *peaks;
 
    if (!peak_name_exists(value, &peak))
    {
	sprintf(error_msg, "peak '%s' unknown", value);
	return  ERROR;
    }
 
    sprintf(error_msg, "allocating memory for peak");
    MALLOC(peaks, int, 1);
    peaks[0] = peak;

    peak_select_func(1, peaks);
 
    return  OK;
}

Status peaks_delete_command(String value, Generic_ptr data, String error_msg)
{
    int npeaks_deleted, npeak_sets;
    int *peaks_deleted;
    Peak_set **peak_sets;

    CHECK_STATUS(peak_delete_func(&npeaks_deleted, &peaks_deleted, error_msg));
     FREE(peaks_deleted, int);
    peak_sets = get_peak_sets(&npeak_sets);
    fit_set_peak_sets(-1, npeak_sets, peak_sets);

    return  OK;
}

Status peaks_load_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(peaks_load_func(NULL, error_msg));

    return  OK;
}

Status peaks_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(peaks_save_func(error_msg));

    return  OK;
}

Status peaks_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status phase_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status phase_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status prop_object_command(String value, Generic_ptr data, String error_msg)
{
    int object;

    if (!object_name_exists(NDATA_OBJECTS, value, &object))
    {
	sprintf(error_msg, "object name '%s' unknown", value);
	return  ERROR;
    }

    prop_object_func(object);

    return  OK;
}

Status prop_select_command(String value, Generic_ptr data, String error_msg)
{
    int property_set;

    if (!data_name_exists(value, &property_set))
    {
        sprintf(error_msg, "data name '%s' unknown", value);
        return  ERROR;
    }

    prop_select_func(property_set);

    return  OK;
}

Status prop_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status prop_get_command(String value, Generic_ptr data, String error_msg)
{
    prop_get_func();

    return  OK;
}

Status prop_set_command(String value, Generic_ptr data, String error_msg)
{
    prop_set_func();

    return  OK;
}

Status prop_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status region_select_command(String value, Generic_ptr data, String error_msg)
{
    int position;

    if (!position_name_exists(value, &position))
    {
	sprintf(error_msg, "saved position '%s' unknown", value);
	return  ERROR;
    }

    CHECK_STATUS(region_select_func(position, error_msg));

    return  OK;
}

Status region_insert_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(region_insert_func(yes_func, error_msg));

    return  OK;
}

Status region_go_to_command(String value, Generic_ptr data, String error_msg)
{
    int type;

    CHECK_STATUS(region_go_to_func(&type, error_msg));

    return  OK;
}

Status region_delete_command(String value, Generic_ptr data, String error_msg)
{
    int position;

    CHECK_STATUS(region_delete_func(&position, error_msg));

    return  OK;
}

Status region_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

static Bool rectangle_func(int *size, int *begin, int *end)
{
    return  FALSE;
}

Status region_stats_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(region_stats_func(&print_funcs, rectangle_func, error_msg));

    return  OK;
}

Status region_dump_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status region_whole_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(region_whole_func(error_msg));

    return  OK;
}

Status region_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status rowcol_select_command(String value, Generic_ptr data, String error_msg)
{
    int rowcol_set;

    if (!data_name_exists(value, &rowcol_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    rowcol_select_func(rowcol_set);

    return  OK;
}

Status rowcol_next_set_command(String value, Generic_ptr data, String error_msg)
{
    int rowcol_set;

    rowcol_next_set_func(&rowcol_set);

    return  OK;
}

Status rowcol_previous_set_command(String value, Generic_ptr data,
							String error_msg)
{
    int rowcol_set;

    rowcol_previous_set_func(&rowcol_set);

    return  OK;
}

Status rowcol_next_point_command(String value, Generic_ptr data,
							String error_msg)
{
    rowcol_next_point_func();

    return  OK;
}

Status rowcol_previous_point_command(String value, Generic_ptr data,
							String error_msg)
{
    rowcol_previous_point_func();

    return  OK;
}

Status rowcol_apply_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status rowcol_stats_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(rowcol_stats_func(&print_funcs, rowcol_limits_func, error_msg));

    return  OK;
}

Status rowcol_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status save_select_command(String value, Generic_ptr data, String error_msg)
{
    int save_set;

    if (!data_name_exists(value, &save_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    save_select_func(save_set);

    return  OK;
}

Status save_save_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(save_save_func(yes_func, error_msg));

    return  OK;
}

extern Status save_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status slice_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status tracking_popup_command(String value, Generic_ptr data, String error_msg)
{
    return  OK;
}

Status region_stats_open(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(region_stats_open_func(value, error_msg));

    return  OK;
}

Status region_stats_close(String value, Generic_ptr data, String error_msg)
{
    region_stats_close_func();

    return  OK;
}
