#ifndef _incl_ps
#define _incl_ps

#include "macros.h"
#include "types.h"

#include "output.h"

typedef struct
{
    FILE *file;
    int type;
    Output_choices *choices;
    String fonts;
}   Ps_data;

/* always do border */
extern void do_ps_border
	(Output_border *border, float x_size, float y_size,
				float x_offset, float y_offset);

/* do border if PS but not if EPS */
extern void ps_border
	(Output_border *border, float x_size, float y_size,
				float x_offset, float y_offset);

extern void start_ps
	(Generic_ptr data);

extern void end_ps
	();

extern void new_ps_range
	(float x0, float y0, float x1, float y1, Bool clip);

extern void ps_line
	(float x0, float y0, float x1, float y1);

extern void ps_left_text
	(String text, float x, float y);

extern void ps_center_horizontal_text
	(String text, float x, float y);

extern void ps_text
	(String text, float x, float y, float a, float b);

extern void set_ps_color
	(int color);

extern void set_ps_font
	(String name, int size);

extern void set_ps_line_style
	(int line_style);

#endif /* _incl_ps */
