#include "prop_popup.h"

#include "property.hlp"

#include "callback.h"
#include "color.h"
#include "data.h"
#include "display_popup.h"
#include "object.h"
#include "window.h"

#define  VISIBLE_ITEMS  7

static Widget property_popup = (Widget) NULL;
static Widget property_form;
static Widget property_list;

static Widget color_field;

static Param_value object_color;

static Textfield_item textfield_items[] =
{
    { "color: ", object_color, NO_CALLBACK, NO_DATA, &color_field }
};

static int ntexts = ARRAY_SIZE(textfield_items);

static int nproperty_sets;

static int nset_selected = 0;
static int *set_selected;

static Data_info *data_info;

void update_property_params()
{
    nproperty_sets = get_ndata_sets();

    data_info = get_data_info();
}

static void get_property_info()
{
    int set;

    if (nset_selected == 0)
	return;

    set = set_selected[0] - 1;

    strcpy(object_color, get_color_name(data_info[set].property.color));

    set_textfields(textfield_items, ntexts);
}

static void set_property_info()
{
    int i, color, set;

    if (nset_selected == 0)
        return;

    get_textfields(textfield_items, ntexts);

    color = get_color_index(object_color);

    for (i = 0; i < nset_selected; i++)
    {
        set = set_selected[i] - 1;

	data_info[set].property.color = color;
    }
}

static Bool find_selected()
{
    if (!property_list)
	return  FALSE;

    return  selection_from_list(property_list, &set_selected, &nset_selected);
}

static void free_selected()
{
    FREE(set_selected, int);
    nset_selected = 0;
}

static void get_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    if (!find_selected())
	return;

    get_property_info();

    free_selected();
}

static void set_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    if (!find_selected())
	return;

    set_property_info();

    free_selected();
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

static String property_string_func(int n, Generic_ptr data)
{
    return  get_data_name(n);
}

static void create_property_popup(Widget parent)
{
    Widget label, buttons, separator, texts;
    Scrolled_list_info property_list_info;
    static Button_item button_items[] =
    {
	{ "apply",	apply_callback,		NO_DATA },
	{ "get",	get_callback,		NO_DATA },
	{ "set",	set_callback,		NO_DATA },
#define  DISMISS_BUTTON  3
	{ "dismiss",	dismiss_callback,	NO_DATA },
	{ "help",	help_callback,		(Callback_ptr) property_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    update_property_params();

    property_popup = create_popup(parent, "Data Set Properties");
    CHECK_WIDGET_WARNING(property_popup);

    property_form = create_form(property_popup);
    CHECK_WIDGET_DESTROY_WARNING(property_form, property_popup);

    label = create_label(property_form, "data sets:");
    CHECK_WIDGET_DESTROY_WARNING(label, property_popup);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);


    property_list_info.selection_policy = MULTIPLE_SELECT;
    property_list_info.nitems = nproperty_sets;
    property_list_info.func = property_string_func;
    property_list_info.nvisible_items = VISIBLE_ITEMS;
    property_list_info.callback = NO_CALLBACK;

    property_list = create_scrolled_list(property_form, &property_list_info);
    CHECK_WIDGET_DESTROY_WARNING(property_list, property_popup);
    attachments(WIDGET_PARENT(property_list), label, NO_ATTACH,
						FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(property_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, property_popup);
    attachments(separator, WIDGET_PARENT(property_list), NO_ATTACH,
						FORM_ATTACH, NO_ATTACH);

    texts = create_textfields(property_form, textfield_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, property_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(property_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, property_popup);
    attachments(separator, texts, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) property_form;
    buttons = create_horizontal_buttons(property_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, property_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, NO_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(property_form);
}

void property_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!property_popup)
	create_property_popup(parent);

    if (property_popup)
	popup(property_form);
}
