#include "object.h"

#include "color.h"
#include "parser.h"
#include "style.h"

#define  DEFAULT_MAJOR_TICKS	5
#define  DEFAULT_MINOR_TICKS	20

static int current_visibility = VISIBILITY_ON;
static int current_color = BLACK;
static int current_style = LINE_STYLE;
static int current_line_style = NORMAL_LINE_STYLE;
static int current_point_style;
static float current_x_scale = 1;
static float current_x_offset = 0;
static float current_y_scale = 1;
static float current_y_offset = 0;

static Global_info global_info;

void get_current_property(Bool first_run, Object_property *property)
{
    if (first_run)
    {
	property->visibility = current_visibility;
	property->color = current_color;
	property->style = current_style;
	property->line_style = current_line_style;
	property->point_style = current_point_style;
    }

    property->x_scale = current_x_scale;
    property->x_offset = current_x_offset;
    property->y_scale = current_y_scale;
    property->y_offset = current_y_offset;
}

Global_info *get_global_info()
{
    return  &global_info;
}

void initialize_properties()
{
    current_x_scale = 1;
    current_y_scale = 1;
    current_x_offset = 0;
    current_y_offset = 0;
}

void initialize_objects()
{
    int i;

    global_info.major_ticks[0] = global_info.major_ticks[1]
							= DEFAULT_MAJOR_TICKS;
    global_info.minor_ticks[0] = global_info.minor_ticks[1]
							= DEFAULT_MINOR_TICKS;

    for (i = 0; i < NGLOBAL_OBJECTS; i++)
    {
	global_info.visibility[i] = VISIBILITY_ON;
	global_info.color[i] = BLACK;
    }

/*  fudge to allow x and y axis color to be set either
    globally or set individually by color of data set  */

    global_info.color[X_AXIS_OBJECT] = -1;
    global_info.color[Y_AXIS_OBJECT] = -1;
}

static Status do_color(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    String name;

    if (first_run)
    {
	name = (String) (store[INPUT_X]->data);
	current_color = get_color_index(name);
    }

    return  OK;
}

static Status do_x_offset(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    store_int_to_float(store[INPUT_X]);
    current_x_offset = *((float *) (store[INPUT_X]->data));

    return  OK;
}

static Status do_y_offset(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    store_int_to_float(store[INPUT_X]);
    current_y_offset = *((float *) (store[INPUT_X]->data));

    return  OK;
}

#define  SMALL_SCALE  1.0e-6
#define  LARGE_SCALE  1.0e6

static Status scale_in_range(float scale, String msg, String error_msg)
{
    if (ABS(scale) < SMALL_SCALE)
    {
	sprintf(error_msg, "%s = %7.2e, must be >= %7.2e in absolute value",
						msg, scale, SMALL_SCALE);
	return  ERROR;
    }

    if (ABS(scale) > LARGE_SCALE)
    {
	sprintf(error_msg, "%s = %7.2e, must be <= %7.2e in absolute value",
						msg, scale, LARGE_SCALE);
	return  ERROR;
    }

    return  OK;
}

static Status do_x_scale(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    store_int_to_float(store[INPUT_X]);
    current_x_scale = *((float *) (store[INPUT_X]->data));

    CHECK_STATUS(scale_in_range(current_x_scale, "x_scale", error_msg));

    return  OK;
}

static Status do_y_scale(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    store_int_to_float(store[INPUT_X]);
    current_y_scale = *((float *) (store[INPUT_X]->data));

    CHECK_STATUS(scale_in_range(current_y_scale, "y_scale", error_msg));

    return  OK;
}

Status init_color(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "color", do_color, error_msg) == ERROR)
	return  ERROR;

    return  OK;
}

Status init_x_offset(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "x_offset", do_x_offset,
							error_msg) == ERROR)
	return  ERROR;

    return  OK;
}

Status init_y_offset(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "y_offset", do_y_offset,
							error_msg) == ERROR)
	return  ERROR;

    return  OK;
}

Status init_x_scale(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "x_scale", do_x_scale,
							error_msg) == ERROR)
	return  ERROR;

    return  OK;
}

Status init_y_scale(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "y_scale", do_y_scale,
							error_msg) == ERROR)
	return  ERROR;

    return  OK;
}
