#include "fft.h"

#include "ft.h"
#include "parser.h"
#include "script.h"
#include "utility.h"

static int m;
static int n;
static float *data_in;
static float *data_out;

#define  SETUP_FT(s, t) \
	 {   n = s * store[INPUT_X]->ndata; \
	     m = ceil_power_of_2(n); \
	     store_int_to_float(store[INPUT_X]); \
	     data_in = (float *) (store[INPUT_X]->data); \
	     store_type_float(store[OUTPUT_X]); \
	   CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], m/t, error_msg)); \
	     data_out = (float *) (store[OUTPUT_X]->data); \
	     COPY_VECTOR(data_out, data_in, n); \
	     ZERO_VECTOR(data_out+n, m-n);   }

static Status do_fft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(2, 2);
    fft(data_out, m);

    return  OK;
}

static Status do_ifft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(2, 2);
    ifft(data_out, m);

    return  OK;
}

static Status do_rft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 2);
    rft(data_out, m);

    return  OK;
}

static Status do_irft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(2, 1);
    irft(data_out, m);

    return  OK;
}

static Status do_cft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    cft(data_out, m);

    return  OK;
}

static Status do_icft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    icft(data_out, m);

    return  OK;
}

static Status do_sft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    sft(data_out, m);

    return  OK;
}

static Status do_isft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    isft(data_out, m);

    return  OK;
}

static Status do_hft(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    hft(data_out, m);

    return  OK;
}

static Status do_fftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(2, 2);
    fftn(data_out, m);

    return  OK;
}

static Status do_ifftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(2, 2);
    ifftn(data_out, m);

    return  OK;
}

static Status do_rftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 2);
    rftn(data_out, m);

    return  OK;
}

static Status do_irftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(2, 1);
    irftn(data_out, m);

    return  OK;
}

static Status do_cftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    cftn(data_out, m);

    return  OK;
}

static Status do_icftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    icftn(data_out, m);

    return  OK;
}

static Status do_sftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    sftn(data_out, m);

    return  OK;
}

static Status do_isftn(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    SETUP_FT(1, 1);
    isftn(data_out, m);

    return  OK;
}

Status init_fft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "fft", do_fft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_ifft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "ifft", do_ifft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_rft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "rft", do_rft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_irft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "irft", do_irft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_cft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "cft", do_cft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_icft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "icft", do_icft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_sft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "sft", do_sft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_isft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "isft", do_isft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_hft(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "hft", do_hft, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_fftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "fftn", do_fftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_ifftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "ifftn", do_ifftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_rftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "rftn", do_rftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FCA;

    return  OK;
}

Status init_irftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "irftn", do_irftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_cftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "cftn", do_cftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_icftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "icftn", do_icftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_sftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "sftn", do_sftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}

Status init_isftn(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "isftn", do_isftn, error_msg) == ERROR)
	return  ERROR;

    store[0]->data_type = PARSER_FRA;

    return  OK;
}
