#ifndef _incl_event_handle
#define _incl_event_handle

#include "widget.h"

typedef void (*Button_handler)(Button button, int x, int y, Time time);
typedef void (*Key_handler)(Key_symbol key, int x, int y, Time time);

typedef struct
{
    Button_handler button_press;
    Button_handler button_release;
    Button_handler pointer_motion;
    Button_handler enter_window;
    Button_handler leave_window;
    Key_handler key_press;
    Key_handler key_release;
}   Event_handlers;

typedef struct
{
    Event_mask mask;
    Event_handlers *handlers;
}   Event_handle;

extern void no_button_handler
	(Button button, int x, int y, Time time);

extern void no_key_handler
	(Key_symbol key, int x, int y, Time time);

extern void add_event_handler
	(Widget widget, Event_handle *handle);

#endif /* _incl_event_handle */
