#include "draw.h"

#include "color.h"
#include "data.h"
#include "object.h"
#include "style.h"

static Status do_axes(Draw_funcs *draw_funcs, Object_property *property,
				Global_info *global,
				float xmin, float xmax,
				float ymin, float ymax, String error_msg)
{
    float x0, y0, x1, y1;
    float x_offset = property->x_offset;
    float y_offset = property->y_offset;

    if (global->visibility[X_AXIS_OBJECT] == VISIBILITY_ON)
    {
	if (global->color[X_AXIS_OBJECT] >= 0)
	    (*(draw_funcs->set_draw_color))(global->color[X_AXIS_OBJECT]);
	else
	    (*(draw_funcs->set_draw_color))(property->color);

	y0 = y1 = y_offset;
	x0 = xmin;
	x1 = xmax;

	(*(draw_funcs->draw_line))(x0, y0, x1, y1);
    }

    if (global->visibility[Y_AXIS_OBJECT] == VISIBILITY_ON)
    {
	if (global->color[Y_AXIS_OBJECT] >= 0)
	    (*(draw_funcs->set_draw_color))(global->color[Y_AXIS_OBJECT]);
	else
	    (*(draw_funcs->set_draw_color))(property->color);

	x0 = x1 = x_offset;
	y0 = ymin;
	y1 = ymax;

	(*(draw_funcs->draw_line))(x0, y0, x1, y1);
    }

    return  OK;
}

static Status do_y_drawing(Draw_funcs *draw_funcs, int ndata, float *data,
				float xmin, float xmax,
				float ymin, float ymax,
				int step, Object_property *property,
				Global_info *global, String error_msg)
{
    int i, imin, imax;
    float x0, y0, x1, y1;
    float x_scale = property->x_scale;
    float y_scale = property->y_scale;
    float x_offset = property->x_offset;
    float y_offset = property->y_offset;

    if (property->visibility == VISIBILITY_OFF)
	return  OK;

    if (do_axes(draw_funcs, property, global, xmin, xmax, ymin, ymax,
							error_msg) == ERROR)
	return  ERROR;

    (*(draw_funcs->set_draw_color))(property->color);

    if (property->style & LINE_STYLE)
    {
	imin = MAX(1, xmin) - 1;
	imax = MIN(ndata, xmax+1);

	x0 = x_scale*(imin+1) + x_offset;
	y0 = y_scale*data[imin*step] + y_offset;

	for (i = imin+1; i < imax; i++)
	{
	    (*(draw_funcs->set_line_style))(property->line_style);

	    x1 = x_scale*(i+1) + x_offset;
	    y1 = y_scale*data[i*step] + y_offset;

	    (*(draw_funcs->draw_line))(x0, y0, x1, y1);

	    x0 = x1;  y0 = y1;
	}
    }

    if (property->style & POINT_STYLE)
    {
    }

    return  OK;
}

Status do_drawing(int start, Draw_info *draw_info, Draw_funcs *draw_funcs,
							String error_msg)
{
    int i, ndata_sets, step, ref_type = draw_info->ref_type;
    String msg;
    Data_info *data_info;
    Global_info *global;
    float *x = draw_info->x;
    float *y = draw_info->y;
    float lower[DISPLAY_DIM], upper[DISPLAY_DIM];
    Bool done[DISPLAY_DIM];

    lower[0] = x[0];  lower[1] = y[0];
    upper[0] = x[1];  upper[1] = y[1];

    (*(draw_funcs->start_draw))(draw_funcs->data);

    ndata_sets = get_ndata_sets();
    data_info = get_data_info();
    global = get_global_info();

/*  Below not quite right if had (X, Y) plot;  fix if/when those used  */
    check_orientation(ref_type, 1, lower, upper);  /* X only */

    (*(draw_funcs->new_draw_range))(lower[0], lower[1],
						upper[0], upper[1], FALSE);

    done[0] = (global->visibility[X_RULER_OBJECT] == VISIBILITY_ON)
							?  TRUE  :  FALSE;

    if (done[0])
    {
	done[1] = FALSE;
	(*(draw_funcs->set_draw_color))(global->color[X_RULER_OBJECT]);
	draw_minor_ticks(global->minor_ticks, done, lower, upper, draw_funcs);
	draw_major_ticks(global->major_ticks, done, lower, upper, draw_funcs);
    }

    done[1] = (global->visibility[Y_RULER_OBJECT] == VISIBILITY_ON)
							?  TRUE  :  FALSE;

    if (done[1])
    {
	done[0] = FALSE;
	(*(draw_funcs->set_draw_color))(global->color[Y_RULER_OBJECT]);
	draw_minor_ticks(global->minor_ticks, done, lower, upper, draw_funcs);
	draw_major_ticks(global->major_ticks, done, lower, upper, draw_funcs);
    }

    for (i = 0; i < ndata_sets; i++)
    {
	sprintf(error_msg, "plot command %d (%s): ",
				i+1, (char *) (data_info[i].name->data));
	msg = error_msg + strlen(error_msg);

	if (data_info[i].y->data_type & PARSER_REAL)
	    step = 1;
	else
	    step = 2;

	if (data_info[i].x)
	{
	}
	else
	{
	    lower[0] = x[0];
	    upper[0] = x[1];

	    convert_range_to_points(ref_type, 1, &(data_info[i].y->ndata),
					data_info[i].ref, lower, upper);

	    (*(draw_funcs->new_draw_range))(lower[0], lower[1],
						upper[0], upper[1], TRUE);

	    if (do_y_drawing(draw_funcs, data_info[i].y->ndata,
				(float *) (data_info[i].y->data),
				lower[0], upper[0], lower[1], upper[1], step,
				&(data_info[i].property), global, msg) == ERROR)
		return  ERROR;
	}
    }

    (*(draw_funcs->end_draw))();

    return  OK;
}
