#ifndef _incl_data
#define _incl_data

#include "macros.h"
#include "types.h"
#include "consts.h"

#include "object.h"
#include "parser.h"
#include "ref.h"

typedef struct
{
    Parser_store *name;
    Parser_store *x;
    Parser_store *y;
    Object_property property;
    Ref_info *ref;
}   Data_info;

extern Status register_data_set
	(int name_arg, int info_arg, int x_arg, int y_arg,
		Parser_store **store, Ref_info *ref, String error_msg);

extern int get_ndata_sets
	();

extern String get_data_name
	(int data_set);

extern Data_info *get_data_info
	();

extern void set_data_visibility
	(int data_set, int visibility);

extern int get_data_visibility
	(int data_set);

extern void print_point_stats
	(int ref_type, float *point, Print_funcs *print_funcs);

extern void print_region_stats
	(int ref_type, float *x, Print_funcs *print_funcs);

#endif /* _incl_data */
