#include "button_popup.h"

#include "button.hlp"

#include "button.h"
#include "callback.h"
#include "display_popup.h"
#include "param.h"
#include "window.h"

static Widget button_popup = (Widget) NULL;
static Widget button_form;

static int nbuttons;
static Textfield_item *button_text;
static Widget *button_field;
static Param_value *button_param;
static int *button_value;

static char next_label[] = "next";
static char previous_label[] = "previous";

#define  SET_VALUE(string, value) \
	 {   sprintf(string, "%d", value);   }

static void set_button_field(int button)
{
    SET_VALUE(button_param[button], button_value[button]);
    set_textfields(button_text+button, 1);
}

static void set_button_fields()
{
    set_textfields(button_text, nbuttons);
}

static void set_button_defaults()
{
    int i;

    for (i = 0; i < nbuttons; i++)
    {
	button_value[i] = button_default(i);
	SET_VALUE(button_param[i], button_value[i]);
    }
}

static void get_button_field(int button)
{
    get_textfields(button_text+button, 1);
    button_value[button] = atoi(button_param[button]);
}

void update_button_params()
{
    if (button_popup)
	get_textfields(button_text, nbuttons);
}

static void next_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int button, command;
    Line error_msg;

    button = ((int *) data) - button_value;
    get_button_field(button);
    button_value[button]++;
    command = change_button(button, button_value[button]);
    set_button_field(button);
 
    if (command >= 0)
	if (do_display_drawing(command, error_msg) == ERROR)
	    ERROR_AND_RETURN(error_msg);
}

static void previous_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    int button, command;
    Line error_msg;

    button = ((int *) data) - button_value;
    get_button_field(button);
    button_value[button]--;
    command = change_button(button, button_value[button]);
    set_button_field(button);
 
    if (command >= 0)
	if (do_display_drawing(command, error_msg) == ERROR)
	    ERROR_AND_RETURN(error_msg);
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int i;
    Line error_msg;

    update_button_params();

    for (i = 0; i < nbuttons; i++)
    {
	button_value[i] = atoi(button_param[i]);
	(void) change_button(i, button_value[i]);
    }

    if (do_display_drawing(0, error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

#define  SCROLLED_WIDTH		500
#define  SCROLLED_HEIGHT	400
#define  SCROLL_BUTTONS		10

static void create_button_popup(Widget parent)
{
    int i;
    Widget buttons, separator, button, sw, sw_form;
    Text_buttons_info text_buttons_info;
    Scrolled_window_info scrolled_info;
    Bool scrolls;
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "apply";
    Button_item text_button_items[2];

    update_button_params();

    button_popup = create_popup(parent, "Buttons");
    CHECK_WIDGET_WARNING(button_popup);

    button_form = create_form(button_popup);
    CHECK_WIDGET_DESTROY_WARNING(button_form, button_popup);

    scrolls = (nbuttons > SCROLL_BUTTONS)  ?  TRUE  :  FALSE;

    if (scrolls)
    {
	scrolled_info.width = SCROLLED_WIDTH;
	scrolled_info.height = SCROLLED_HEIGHT;
	sw = create_scrolled_window(button_form, &scrolled_info);
	CHECK_WIDGET_DESTROY_WARNING(sw, button_popup);
	attachments(sw, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

	sw_form = create_form(sw);
	CHECK_WIDGET_DESTROY_WARNING(sw_form, button_popup);
	attachments(sw_form, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH,
								FORM_ATTACH);
    }
    else
    {
	sw_form = button_form;
    }

    separator = FORM_ATTACH;

    set_button_defaults();

    text_buttons_info.nbuttons = 2;
    text_buttons_info.buttons = text_button_items;

    text_button_items[0].callback = next_callback;
    text_button_items[1].callback = previous_callback;

    for (i = 0; i < nbuttons; i++)
    {
	button_text[i].label = button_label(i);
	text_buttons_info.text = button_text + i;

	text_button_items[0].label = next_label;
	text_button_items[0].data = (Generic_ptr) (button_value + i);

	text_button_items[1].label = previous_label;
	text_button_items[1].data = (Generic_ptr) (button_value + i);

	button = create_text_buttons(sw_form, &text_buttons_info);
	CHECK_WIDGET_DESTROY_WARNING(button, button_popup);
	attachments(button, separator, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

	separator = create_separator(sw_form);
	CHECK_WIDGET_DESTROY_WARNING(separator, button_popup);
	attachments(separator, button, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    }

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = apply_callback;
    adh_info.dismiss_form = button_form;
    adh_info.help_message = button_help;

    buttons = create_apply_dismiss_help(button_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, button_popup);

    if (scrolls)
	attachments(buttons, sw, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    else
	attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);

    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    set_button_fields();

    if (scrolls)
    {
	manage_widget(sw_form);
	manage_widget(sw);
    }

    manage_widget(button_form);
}

static Status alloc_button_popup_memory()
{
    int i;

    if (nbuttons == 0)
	return  OK;

    MALLOC(button_text, Textfield_item, nbuttons);
    MALLOC(button_field, Widget, nbuttons);
    MALLOC(button_param, Param_value, nbuttons);

    MALLOC(button_value, int, nbuttons);

    for (i = 0; i < nbuttons; i++)
    {
	button_text[i].value = button_param[i];
	button_text[i].callback = (Callback_proc) NULL;
	button_text[i].data = (Callback_ptr) NULL;
	button_text[i].field = &button_field[i];
    }

    return  OK;
}

void button_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!button_popup)
    {
	nbuttons = number_buttons();
	if (alloc_button_popup_memory() == ERROR)
	    ERROR_AND_EXIT("allocating button popup memory");

	create_button_popup(parent);
    }

    if (button_popup)
	popup(button_form);
}
