#include "baseline.h"

#include "base.h"
#include "parser.h"
#include "script.h"

#define  BASELINE_W		2
#define  BASELINE_O		3
#define  BASELINE_F		4
#define  BASELINE_L		5
#define  BASELINE_POINTS	6

#define  BASE_POINT_FILE	2
#define  BASE_POINT_POINTS	3

#define  BASE_SUBTRACT_FILE	2
#define  BASE_SUBTRACT_F	3
#define  BASE_SUBTRACT_L	4

#define  SETUP_BASELINE \
	 {   n = store[INPUT_X]->ndata; \
	     store_int_to_float(store[INPUT_X]); \
	     data_in = (float *) (store[INPUT_X]->data); \
	     store_type_float(store[OUTPUT_X]); \
	     CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], n, error_msg)); \
	     data_out = (float *) (store[OUTPUT_X]->data); \
	     if (store[BASELINE_POINTS]) \
	     {   have_base_points = TRUE; \
		 nbase_points = store[BASELINE_POINTS]->ndata; \
		 base_points = (int *) (store[BASELINE_POINTS]->data);   } \
	     else   {   have_base_points = FALSE;   }   }

#define  FIND_BASELINE_POINTS \
	 {   if (!have_base_points) \
	     {   if (!find_baseline(npoints, width, &avg_min_chisq, \
			&nchisq, data_out+first, &nbaseline, &baseline)) \
		return;   }   }

static int n;
static float *data_in;
static float *data_out;

static int npoints;
static int npoints_orig;
static int width;
static int order;
static int first;

static float avg_min_chisq;
static int nchisq;

static Bool have_base_points = FALSE;
static int nbase_points = 0;
static int *base_points;
static int nbase_pnts_alloc = 0;
static int *base_pnts = (int *) NULL;
static int nbaseline;
static int *baseline;
static int ndata_base_points;

static int nbase_values_alloc = 0;
static float *base_values = (float *) NULL;

static Parser_store *base_points_store = (Parser_store *) NULL;

static Status alloc_base_pnts_memory()
{
    if (nbase_points > nbase_pnts_alloc)
    {
	FREE(base_pnts, int);
	nbase_pnts_alloc = 0;

	MALLOC(base_pnts, int, nbase_points);
	nbase_pnts_alloc = nbase_points;
    }

    return  OK;
}

static Status init_do_base(Bool have_range, int w2, int o, int f, int l,
							String error_msg)
{
    if ((!have_base_points) && (w2 < 1))
        RETURN_ERROR_MSG("half width must be >= 1");

    if (o < 1)
        RETURN_ERROR_MSG("order must be >= 1");

    if (have_range)
    {
        if (f < 1)
            RETURN_ERROR_MSG("first point must be >= 1");

        if (l <= f)
            RETURN_ERROR_MSG("last point must be > first point");

        if (l > n)
            RETURN_ERROR_MSG("last point must be <= #points");

        npoints = l - f + 1;
        first = f - 1;
    }
    else
    {
        npoints = n;
        first = 0;
    }

    if (have_base_points)
    {
        if (n != ndata_base_points)
            RETURN_ERROR_MSG("inconsistent #points compared to 'base_points'");

	if (have_range)
	{
	    if (alloc_base_pnts_memory() == ERROR)
		RETURN_ERROR_MSG("allocating memory");

	    range_base_points(first, l, nbase_points, base_points,
						&nbaseline, base_pnts);
	    baseline = base_pnts;
	}
	else
	{
	    nbaseline = nbase_points;
	    baseline = base_points;
	}

	if (nbaseline < o)
	{
	    sprintf(error_msg,
		"from file have %d baseline points, must have at least %d",
								nbaseline, o);
	    return  ERROR;
	}
    }

    npoints_orig = n;
    width = 2*w2 + 1;
    order = o;

    avg_min_chisq = 0;
    nchisq = 0;

    if (!have_base_points && (npoints < width))
        RETURN_ERROR_MSG("width too large for given #points");

    if (npoints < order)
        RETURN_ERROR_MSG("order too large for given #points");

    if (alloc_baseline(npoints, order) == ERROR)
        RETURN_ERROR_MSG("allocating memory");

    COPY_VECTOR(data_out, data_in, n);

    return  OK;
}

static void do_const_base()
{
    FIND_BASELINE_POINTS;

    fit_const_baseline(npoints, data_out+first, nbaseline, baseline);
}

static void do_poly_base()
{
    FIND_BASELINE_POINTS;

    fit_poly_baseline(npoints, order, data_out+first, nbaseline, baseline);
}

static void do_trig_base()
{
    FIND_BASELINE_POINTS;

    fit_trig_baseline(npoints, npoints_orig, order, data_out+first,
							nbaseline, baseline);
}

static Status do_base_const(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int w2;

    SETUP_BASELINE;

    store_float_to_int(store[BASELINE_W]);

    w2 = *((int *) store[BASELINE_W]->data);

    CHECK_STATUS(init_do_base(FALSE, w2, 1, 0, 0, error_msg));

    do_const_base();

    return  OK;
}

static Status do_base_const2(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int w2, f, l;

    SETUP_BASELINE;

    store_float_to_int(store[BASELINE_W]);

    w2 = *((int *) store[BASELINE_W]->data);
    f = *((int *) store[BASELINE_F-1]->data);  /* note the -1 */
    l = *((int *) store[BASELINE_L-1]->data);

    CHECK_STATUS(init_do_base(TRUE, w2, 1, f, l, error_msg));

    do_const_base();

    return  OK;
}

static Status do_base_poly(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int w2, o;

    SETUP_BASELINE;

    store_float_to_int(store[BASELINE_W]);

    w2 = *((int *) store[BASELINE_W]->data);
    o = *((int *) store[BASELINE_O]->data) + 1;

    CHECK_STATUS(init_do_base(FALSE, w2, o, 0, 0, error_msg));

    if (o > 1)
	do_poly_base();
    else
	do_const_base();

    return  OK;
}

static Status do_base_poly2(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int w2, o, f, l;

    SETUP_BASELINE;

    store_float_to_int(store[BASELINE_W]);

    w2 = *((int *) store[BASELINE_W]->data);
    o = *((int *) store[BASELINE_O]->data) + 1;
    f = *((int *) store[BASELINE_F]->data);
    l = *((int *) store[BASELINE_L]->data);

    CHECK_STATUS(init_do_base(TRUE, w2, o, f, l, error_msg));

    if (o > 1)
	do_poly_base();
    else
	do_const_base();

    return  OK;
}

static Status do_base_trig(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int w2, o;

    SETUP_BASELINE;

    store_float_to_int(store[BASELINE_W]);

    w2 = *((int *) store[BASELINE_W]->data);
    o = *((int *) store[BASELINE_O]->data);
    o = 2*o + 1;

    CHECK_STATUS(init_do_base(FALSE, w2, o, 0, 0, error_msg));

    if (o > 1)
	do_trig_base();
    else
	do_const_base();

    return  OK;
}

static Status do_base_trig2(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int w2, o, f, l;

    SETUP_BASELINE;

    store_float_to_int(store[BASELINE_W]);

    w2 = *((int *) store[BASELINE_W]->data);
    o = *((int *) store[BASELINE_O]->data);
    o = 2*o + 1;
    f = *((int *) store[BASELINE_F]->data);
    l = *((int *) store[BASELINE_L]->data);

    CHECK_STATUS(init_do_base(TRUE, w2, o, f, l, error_msg));

    if (o > 1)
	do_trig_base();
    else
	do_const_base();

    return  OK;
}

static Status do_base_points(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    int nread, n, *b;
    String file = (String) (store[BASE_POINT_FILE]->data);

    ndata_base_points = n = store[INPUT_X]->ndata;

    if (n < 1)
	RETURN_ERROR_MSG("must have #base_points > 0");

    CHECK_STATUS(check_parser_alloc(store[BASE_POINT_POINTS], n, error_msg));

    b = (int *) (store[BASE_POINT_POINTS]->data);

    CHECK_STATUS(read_base_points(file, n, &nread, b, error_msg));

    store[BASE_POINT_POINTS]->ndata = nread;

    return  OK;
}

/*
static Status do_end_base_points(Bool first_run, int nstore,
					Parser_store **store, String error_msg)
{
    return  OK;
}
*/

static Status alloc_base_sub_memory()
{
    if (npoints > nbase_values_alloc)
    {
	FREE(base_values, float);
	nbase_values_alloc = 0;

	MALLOC(base_values, float, npoints);
	nbase_values_alloc = npoints;
    }

    return  OK;
}

static do_subtract_base(String file, Bool have_range, int f, int l,
							String error_msg)
{
    float *d_in, *d_out;

    if (have_range)
    {
        if (f < 1)
            RETURN_ERROR_MSG("first point must be >= 1");

        if (l <= f)
            RETURN_ERROR_MSG("last point must be > first point");

        if (l > n)
            RETURN_ERROR_MSG("last point must be <= #points");

        npoints = l - f + 1;
        first = f - 1;
    }
    else
    {
        npoints = n;
        first = 0;
    }

    if (alloc_base_sub_memory() == ERROR)
        RETURN_ERROR_MSG("allocating memory");

    CHECK_STATUS(read_base_values(file, npoints, base_values, error_msg));

    d_in = data_in + first;
    d_out = data_out + first;

    SUBTRACT_VECTORS(d_out, d_in, base_values, npoints);

    return  OK;
}

static Status do_base_subtract(Bool first_run, int nstore,
					Parser_store **store, String error_msg)
{
    String file;

    SETUP_BASELINE;

    file = (String) (store[BASE_SUBTRACT_FILE]->data);

    CHECK_STATUS(do_subtract_base(file, FALSE, 0, 0, error_msg));

    return  OK;
}

static Status do_base_subtract2(Bool first_run, int nstore,
					Parser_store **store, String error_msg)
{
    int f, l;
    String file;

    SETUP_BASELINE;

    file = (String) (store[BASE_SUBTRACT_FILE]->data);
    f = *((int *) store[BASE_SUBTRACT_F]->data);
    l = *((int *) store[BASE_SUBTRACT_L]->data);

    CHECK_STATUS(do_subtract_base(file, TRUE, f, l, error_msg));

    return  OK;
}

static Status init_base(int nstore, Parser_store **store, String cmd_msg,
					Command_func func, String error_msg)
{
    int i;

/*  routines have differing amounts of nstore, initialize properly  */
    for (i = nstore; i < BASELINE_POINTS; i++)
	store[i] = (Parser_store *) NULL;

    if (have_base_points)
	store[BASELINE_POINTS] = base_points_store;
    else
	store[BASELINE_POINTS] = (Parser_store *) NULL;

/*  +1 below because of BASELINE_POINTS above  */
/*  cannot use nstore+1 because routines have differing amounts of nstore  */
    if (setup_command(BASELINE_POINTS+1, store, cmd_msg, func,
							error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}

Status init_base_const(int nstore, Parser_store **store, String error_msg)
{
    return  init_base(nstore, store, "base_const", do_base_const, error_msg);
}

Status init_base_const2(int nstore, Parser_store **store, String error_msg)
{
    return  init_base(nstore, store, "base_const2", do_base_const2, error_msg);
}

Status init_base_poly(int nstore, Parser_store **store, String error_msg)
{
    return  init_base(nstore, store, "base_poly", do_base_poly, error_msg);
}

Status init_base_poly2(int nstore, Parser_store **store, String error_msg)
{
    return  init_base(nstore, store, "base_poly2", do_base_poly2, error_msg);
}

Status init_base_trig(int nstore, Parser_store **store, String error_msg)
{
    return  init_base(nstore, store, "base_trig", do_base_trig, error_msg);
}

Status init_base_trig2(int nstore, Parser_store **store, String error_msg)
{
    return  init_base(nstore, store, "base_trig2", do_base_trig2, error_msg);
}

Status init_base_points(int nstore, Parser_store **store, String error_msg)
{
    if (have_base_points)
	RETURN_ERROR_MSG("missing previous 'end_base_points'");

    MALLOC(base_points_store, Parser_store, 1);

    base_points_store->ndata = base_points_store->nalloc = 0;
    base_points_store->data_type = PARSER_IRA;
    base_points_store->data = (Generic_ptr) NULL;

    store[BASE_POINT_POINTS] = base_points_store;

/*  +1 below because of BASE_POINT_POINTS above  */
    if (setup_command(nstore+1, store, "base_points", do_base_points,
							error_msg) == ERROR)
	return  ERROR;

    have_base_points = TRUE;

    return  OK;
}

Status init_end_base_points(int nstore, Parser_store **store, String error_msg)
{
    if (!have_base_points)
	RETURN_ERROR_MSG("missing previous 'base_points'");

    have_base_points = FALSE;

/*
    if (setup_command(nstore, store, "end_base_points", do_end_base_points,
							error_msg) == ERROR)
	return  ERROR;
*/

    return  OK;
}

Status init_base_subtract(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "base_subtract", do_base_subtract,
							error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}

Status init_base_subtract2(int nstore, Parser_store **store, String error_msg)
{
    if (setup_command(nstore, store, "base_subtract2", do_base_subtract2,
							error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = store[INPUT_X]->data_type;
    store[OUTPUT_X]->data_type |= PARSER_INT | PARSER_FLOAT;

    return  OK;
}
