#include "avance.h"

#include "parser.h"
#include "script.h"

#include "avance_param.h"
#include "phase.h"

#define  AVANCE_DSPFVS	2
#define  AVANCE_DECIM	3
#define  AVANCE_ANGLE	4

#define  DEFAULT_ANGLE  180.0

/* used to store parameters between call to avance/avance2 and avance_phase */
static Avance_param param;
static Bool have_avance = FALSE;

static Status do_avance_shift(float angle, Parser_store **store,
							String error_msg)
{
    int m, n;
    float *data_in, *data_out;

    if (have_avance) /* only really need to check first time through */
	RETURN_ERROR_MSG("script missing 'avance_phase'");

    n = store[INPUT_X]->ndata;
    store_int_to_float(store[INPUT_X]);
    data_in = (float *) (store[INPUT_X]->data);

    store_int_to_float(store[AVANCE_DSPFVS]);
    param.dspfvs = *((float *) (store[AVANCE_DSPFVS]->data));

    store_int_to_float(store[AVANCE_DECIM]);
    param.decim = *((float *) (store[AVANCE_DECIM]->data));

    param.angle = angle;
    CHECK_STATUS(find_avance_param(&param, error_msg));

    m = n - param.shift;

    if (m <= 0)
	RETURN_ERROR_MSG("not enough points to shift");

    store_type_float(store[OUTPUT_X]);
    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], m, error_msg));
    data_out = (float *) (store[OUTPUT_X]->data);

    data_in += 2 * param.shift; /* 2 because complex data */
    m *= 2;

    COPY_VECTOR(data_out, data_in, m);

    return  OK;
}

static Status do_avance(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    float angle;

    angle = DEFAULT_ANGLE;

    return  do_avance_shift(angle, store, error_msg);
}

static Status do_avance2(Bool first_run, int nstore, Parser_store **store,
							String error_msg)
{
    float angle;

    store_int_to_float(store[AVANCE_ANGLE]);
    angle = *((float *) (store[AVANCE_ANGLE]->data));

    return  do_avance_shift(angle, store, error_msg);
}

static Status do_avance_phase(Bool first_run, int nstore,
				Parser_store **store, String error_msg)
{
    int n;
    float *data_in, *data_out;

    n = store[INPUT_X]->ndata;
    store_int_to_float(store[INPUT_X]);
    data_in = (float *) (store[INPUT_X]->data);

    store_type_float(store[OUTPUT_X]);
    CHECK_STATUS(check_parser_alloc(store[OUTPUT_X], n, error_msg));
    data_out = (float *) (store[OUTPUT_X]->data);

    /* assumes avance or avance2 has been called */
    calculate_phasing(0.0, param.ph0, param.ph1, n, data_in, data_out);

    return  OK;
}

Status init_avance(int nstore, Parser_store **store, String error_msg)
{
    if (have_avance)
	RETURN_ERROR_MSG("missing previous 'avance_phase'");

    if (setup_command(nstore, store, "avance", do_avance, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FCA;

    have_avance = TRUE;

    return  OK;
}

Status init_avance2(int nstore, Parser_store **store, String error_msg)
{
    if (have_avance)
	RETURN_ERROR_MSG("missing previous 'avance_phase'");

    if (setup_command(nstore, store, "avance2", do_avance2, error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FCA;

    have_avance = TRUE;

    return  OK;
}

Status init_avance_phase(int nstore, Parser_store **store, String error_msg)
{
    if (!have_avance)
	RETURN_ERROR_MSG("missing previous 'avance' or 'avance2'");

    if (setup_command(nstore, store, "avance_phase", do_avance_phase,
							error_msg) == ERROR)
	return  ERROR;

    store[OUTPUT_X]->data_type = PARSER_FCA;

    have_avance = FALSE;

    return  OK;
}
