#ifndef _incl_dbl_list
#define _incl_dbl_list

#include "macros.h"
#include "types.h"

#define  DBL_DATA(L)		((L)->data_ptr)
#define  DBL_NEXT(L)		((L)->next)
#define  DBL_PREVIOUS(L)	((L)->previous)

typedef struct dbl_node
{
    Generic_ptr data_ptr;
    struct dbl_node *next;
    struct dbl_node *previous;
}   Dbl_node, *Dbl_list;

extern Status allocate_dbl_node
	(Dbl_list *p_dbl_list, Generic_ptr data_ptr);

extern void free_dbl_node
	(Dbl_list *p_dbl_list);

extern Status init_dbl_list
	(Dbl_list *p_dbl_list);

extern Bool empty_dbl_list
	(Dbl_list dbl_list);

extern Status insert_dbl_list
	(Dbl_list *p_dbl_list, Generic_ptr data_ptr);

extern Status traverse_dbl_list
	(Dbl_list dbl_list, Check_func func);

extern Dbl_list dbl_list_iterator
	(Dbl_list dbl_list, Dbl_list last_return);

extern void destroy_dbl_list
	(Dbl_list *p_dbl_list, Data_func func);

extern void move_dbl_list_to_front
	(Dbl_list *p_dbl_list, Dbl_list dbl_list);

#endif /* _incl_dbl_list */
