#include "timer.h"

#include "utility.h"
#include "window.h"

static Widget topshell;
static Widget timer = (Widget) NULL;
static Widget timer_form;
static Widget announce;
static Widget label;
static Widget drawing;
static Widget button;
static Cursor cursor;

static Display *display;
static Window drawing_window;
static Window button_window;
static GC gc;

static Dimension width;
static Dimension height;

static Bool timing = FALSE;
static int timer_abort;

static float current_fraction;

static Bool normal_timer = TRUE;

static int check_for_interrupt()
{
    XEvent event;

    XFlush(display);

    XmUpdateDisplay(topshell);

    while (XCheckMaskEvent(display,
		ButtonPressMask | ButtonReleaseMask | ButtonMotionMask |
		PointerMotionMask | KeyPressMask | KeyReleaseMask,
		&event))
    {
	if (event.xany.window == button_window)
	    XtDispatchEvent(&event);
    }

    return  timer_abort;
}

static void draw_bubble()
{
    Dimension w;

    w = current_fraction * width;
    XFillRectangle(display, drawing_window, gc, 0, 0, w, height);
    XClearArea(display, drawing_window, w, 0, width-w, height, False);

    XDrawLine(display, drawing_window, gc, w, 0, w, height-1);
    XDrawLine(display, drawing_window, gc, w, 0, width-1, 0);
    XDrawLine(display, drawing_window, gc, w, height-1, width-1, height-1);
    XDrawLine(display, drawing_window, gc, width-1, 0, width-1, height-1);
}

void stop_timer(Status status)
{
    if (!normal_timer)
    {
	stop_screen_timer(status);
	return;
    }

    if (!timing)
	return;

    if (status == OK)
    {
    	current_fraction = 1.0;
    	draw_bubble();
    	set_label(label, "100% done");
    	set_label(announce, "Finished");
    }

    set_label(button, "Dismiss");

    change_cursor(None);
    timing = FALSE;

    force_update(timer);
}

int update_timer(float fraction)
{
    int percent;
    char message[10];

    if (!normal_timer)
	return  update_screen_timer(fraction);

    percent = 100.0 * fraction;
    sprintf(message, "%d%% done", percent);
    set_label(label, message);

    current_fraction = fraction;
    draw_bubble();

    return  check_for_interrupt();
}

static void action_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    if (timing)
    {
	if (force_question("Do you really\nwant to abort?",
					"Yes", "No", (String) NULL) == YES)
	{
	    timer_abort = ABORT;
	}

	popup(timer_form);
    }
    else
    {
    	popdown(timer_form);
    }
}

static void expose(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    draw_bubble();
}

static void resize(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    XtVaGetValues(widget, XmNwidth, &width, XmNheight, &height, NULL);
}

static void create_timer_popup()
{
    Widget separator;
    XGCValues gcv;
    Drawing_area_info drawing_info;
/*
    Button_item button_items[] =
    {
        { "Abort",	action_callback,	NO_DATA }
    };
    int nbuttons = ARRAY_SIZE(button_items);
*/

    topshell = get_topshell();

    timer = XtVaCreatePopupShell("timer",
		xmDialogShellWidgetClass,	topshell,
		XmNdeleteResponse,		XmDO_NOTHING,
		NULL);

    register_shell(timer);

    timer_form = create_form(timer);

#define  BLANK_LINE  "                              "
    announce = create_label(timer_form, BLANK_LINE);
    attachments(announce, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(timer_form);
    attachments(separator, announce, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    label = create_label(timer_form, "0% done");
    attachments(label, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    drawing_info.width = 300;
    drawing_info.height = 30;
    drawing_info.expose = expose;
    drawing_info.resize = resize;

    drawing = create_drawing(timer_form, &drawing_info);
    attachments(drawing, label, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    button = XtVaCreateManagedWidget("Buttons",
		xmPushButtonWidgetClass,	timer_form,
		NULL);

/*
    button = create_horizontal_buttons(timer_form, button_items, nbuttons);
*/

    attachments(button, drawing, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(button, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET, UNIT_OFFSET);

    XtAddCallback(button, XmNactivateCallback, action_callback, NULL);

    manage_widget(timer_form);

    cursor = XCreateFontCursor(WIDGET_DISPLAY(topshell), XC_watch);

    display = WIDGET_DISPLAY(drawing);
    drawing_window = WIDGET_WINDOW(drawing);
    button_window = WIDGET_WINDOW(button);

    gcv.foreground = BlackPixelOfScreen(WIDGET_SCREEN(drawing));
    gcv.background = WhitePixelOfScreen(WIDGET_SCREEN(drawing));
    gc = XCreateGC(display, drawing_window, GCForeground | GCBackground, &gcv);
}

void start_timer(String message)
{
    if (!normal_timer)
    {
	start_screen_timer(message);
	return;
    }

    if (timing)
	return;

    if (!timer)
	create_timer_popup();

    set_label(announce, message);
    set_label(label, "0% done");
    set_label(button, "Abort");

    current_fraction = 0.0;
    draw_bubble();

    change_cursor(cursor);
    timing = TRUE;
    timer_abort = CONTINUE;

    popup(timer_form);

    force_update(timer);
}

void set_screen_timer()
{
    normal_timer = FALSE;
}

void set_normal_timer()
{
    normal_timer = TRUE;
}
