/*  ref_parse.c  */

static Status sw_parse(Generic_ptr *var, String error_msg)
{
    float x = *((float *) *var);

    CHECK_DIM_THERE("sw");

    if (ABS(x) < SMALL_SW)
	NOT_ALLOWED_FOR_DIM(dim, "sw", "too small");

    ref[dim].sw = x;

    return  OK;
}

static Status sf_parse(Generic_ptr *var, String error_msg)
{
    float x = *((float *) *var);

    CHECK_DIM_THERE("sf");

    if (ABS(x) < SMALL_SF)
	NOT_ALLOWED_FOR_DIM(dim, "sf", "too small");

    ref[dim].sf = x;

    return  OK;
}

static Status refppm_parse(Generic_ptr *var, String error_msg)
{
    float x = *((float *) *var);

    CHECK_DIM_THERE("refppm");

    ref[dim].refppm = x;

    return  OK;
}

static Status refpt_parse(Generic_ptr *var, String error_msg)
{
    float x = *((float *) *var);

    CHECK_DIM_THERE("refpt");

    ref[dim].refpt = x;

    return  OK;
}

static Status nuc_parse(Generic_ptr *var, String error_msg)
{
    CHECK_DIM_THERE("nuc");

    strcpy(ref[dim].nuc, (char *) var[0]);

    return  OK;
}
