#include "info_popup.h"

#include "callback.h"
#include "window.h"

#include "info.hlp"

static Widget info_popup = (Widget) NULL;
static Widget info_form;
static Widget info_text;

static Bool new_text;

#define  INFO_NROWS	18
#define  INFO_NCOLS	60

static void create_info_popup(Widget parent)
{
    static Widget buttons;
    static Scrolled_text_info scrolled_text_info =
	{ INFO_NROWS, INFO_NCOLS, FALSE, MULTI_LINE_EDIT };
    static Button_item button_items[] =
    {
#define  DISMISS_BUTTON  0
	{ "dismiss",	dismiss_callback,	NO_DATA  },
	{ "help",	help_callback,		(Callback_ptr) info_help }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    info_popup = create_popup(parent, "Information");
    CHECK_WIDGET_WARNING(info_popup);

    info_form = create_form(info_popup);
    CHECK_WIDGET_DESTROY_WARNING(info_form, info_popup);

    button_items[DISMISS_BUTTON].data = (Callback_ptr) info_form;
    buttons = create_horizontal_buttons(info_form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY_WARNING(buttons, info_popup);
/*
    attachments(buttons, WIDGET_PARENT(info_text), FORM_ATTACH, NO_ATTACH,
								FORM_ATTACH);
*/
    attachments(buttons, NO_ATTACH, FORM_ATTACH, NO_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    info_text = create_scrolled_text(info_form, &scrolled_text_info);
    CHECK_WIDGET_DESTROY_WARNING(info_text, info_popup);
/*
    attachments(info_text, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
*/
    attachments(WIDGET_PARENT(info_text), FORM_ATTACH, buttons, FORM_ATTACH,
								FORM_ATTACH);

    manage_widget(info_form);
}

Status start_info(String error_msg)
{
    if (!info_popup)
	create_info_popup(get_topshell());

    if (info_popup)
	popup(info_form);

    new_text = TRUE;

    return  OK;  /* even if not OK since would already have had error message */
}

void print_info(String message)
{
    if (info_popup)
    {
	print_text(info_text, new_text, message);
	new_text = FALSE;
    }
}

void end_info()
{
}
