#include "block.h"

#include "block_io.h"

#define  NPRINTS_TO_DO  32

static Block_IO block_io_in;
static Block_IO block_io_out;

static Status process_block(int block, float *data, String error_msg)
{
    CHECK_STATUS(read_file_block(&block_io_in, block, data, error_msg));
    CHECK_STATUS(write_file_block(&block_io_out, block, data, error_msg));

    return  OK;
}

Status block_process(Store_info *store_info, File_info *file_info,
			Deflate_info *deflate_info, String error_msg)
{
    int i, n, nblocks, nstore;

    if (!(file_info->blocked))
	RETURN_ERROR_MSG("input file must be blocked");

    nblocks = deflate_info->nblocks;
    nstore = store_info->nstore;

    block_io_in.name = file_info->input_file;
    block_io_in.file = file_info->file_in;
    block_io_in.swapped = file_info->swapped;
    block_io_in.integer = FALSE;
    block_io_in.deflated = FALSE;
    block_io_in.header = 0;
    block_io_in.block_size = nstore;
    block_io_in.byte_size = BYTES_PER_WORD;

    block_io_out.name = file_info->output_file;
    block_io_out.file = file_info->file_out;
    block_io_out.deflated = TRUE;
    block_io_out.dir_size = store_info->dir_size;
    block_io_out.directory = store_info->directory;
    block_io_out.block_size = nstore;
    block_io_out.level = deflate_info->level;

    CHECK_STATUS(init_block_read(&block_io_in, error_msg));
    CHECK_STATUS(init_block_write(&block_io_out, error_msg));

    printf("%d blocks to deflate\n", nblocks);

    n = nblocks / NPRINTS_TO_DO;
    n = MAX(n, 1);

    for (i = 0; i < nblocks; i++)
    {
	if (!(i % n))
	{
	    printf("\t... working on block %d of %d\n", i+1, nblocks);
	    FLUSH;
	}

	CHECK_STATUS(process_block(i, store_info->store, error_msg));
    }

    CHECK_STATUS(end_block_write(&block_io_out, error_msg));

    printf("deflation ratio = %5.1f\n",
	nstore*((float) nblocks)/(store_info->dir_size+block_io_out.last_done));

    return  OK;
}
