#include "table.h"

#define  PARSE_SEPARATOR	'\t'

Status get_table_entry(String *line, String entry, String error_msg)
{
    String ptr2;
    static int col;
    static String ptr;
    static Long_line store;

    if (*line)
    {
	strcpy(store, *line);
	ptr = store;
	col = 1;
    }
    else
    {
	col++;
    }

    sprintf(error_msg, "column #%d: ", col);
    error_msg += strlen(error_msg);

    if (!(*ptr))
    {
	RETURN_ERROR_MSG("missing data")
    }

    if ((ptr2 = strchr(ptr, PARSE_SEPARATOR)) || (ptr2 = strchr(ptr, NEW_LINE)))
	*ptr2++ = 0;
    else
	ptr2 = ptr + strlen(ptr);

    strcpy(entry, ptr);
    ptr = ptr2;

    *line = NULL;

    return  OK;
}

Status get_table_integer(String *line, int *x, String error_msg)
{
    Line entry;

    CHECK_STATUS(get_table_entry(line, entry, error_msg));

    *x = atoi(entry);

    return  OK;
}

Status get_table_float(String *line, float *x, String error_msg)
{
    Line entry;

    CHECK_STATUS(get_table_entry(line, entry, error_msg));

    *x = atof(entry);

    return  OK;
}

Status get_table_string(String *line, String *x, String error_msg)
{
    Line entry;
    String p;

    CHECK_STATUS(get_table_entry(line, entry, error_msg));

    sprintf(error_msg, "allocating memory");
    STRING_MALLOC_COPY(p, entry);

    *x = p;

    return  OK;
}
