#include "shift.h"

#include "atom.h"
#include "table.h"

#define  PARSE_SEPARATOR	"\t"

#define  SHIFT_ALLOC		1000

static int nshifts = 0;
static int nshifts_alloc = 0;
static Shift **shifts;

static Status alloc_shift_memory(String error_msg)
{
    int i, n;

    if (nshifts >= nshifts_alloc)
    {
	n = nshifts_alloc + SHIFT_ALLOC;

	if (nshifts_alloc == 0)
	{
	    sprintf(error_msg, "allocating memory");
	    MALLOC(shifts, Shift *, n);
	}
	else
	{
	    sprintf(error_msg, "reallocating memory");
	    REALLOC(shifts, Shift *, n);
	}

	sprintf(error_msg, "allocating memory");

	for (i = nshifts_alloc; i < n; i++)
	    MALLOC(shifts[i], Shift, 1);

	nshifts_alloc = n;
    }

    return  OK;
}

static Status parse_shift(Shift *shift, String line, String error_msg)
{
    int residue;
    Line chain;
    String residue_chain;

    Atom *light = shift->atom + LIGHT_ATOM;
    Atom *heavy = shift->atom + HEAVY_ATOM;

    CHECK_STATUS(get_table_string(&line, &(light->res_name), error_msg));
/*  added chain check 13 Sep 00, which means now parse residue_chain below
    CHECK_STATUS(get_table_integer(&line, &(light->residue), error_msg));
*/
    CHECK_STATUS(get_table_string(&line, &residue_chain, error_msg));
    CHECK_STATUS(get_table_string(&line, &(light->atom_name), error_msg));
    CHECK_STATUS(get_table_float(&line, &(light->shift), error_msg));
    CHECK_STATUS(get_table_string(&line, &(heavy->atom_name), error_msg));
    CHECK_STATUS(get_table_float(&line, &(heavy->shift), error_msg));
    CHECK_STATUS(get_table_float(&line, &(light->delta), error_msg));
    CHECK_STATUS(get_table_float(&line, &(heavy->delta), error_msg));
 
    CHECK_STATUS(find_atom_type(light->atom_name, &(light->atom_type), error_msg));

    if (sscanf(residue_chain, "%d%s", &residue, chain) != 2)
    {
	if (sscanf(residue_chain, "%d", &residue) != 1)
	    residue = 0;

	*chain = 0;
    }

    light->residue = residue;
    STRING_MALLOC_COPY(light->chain, chain);
    FREE(residue_chain, char);

    if (light->atom_type != HYDROGEN)
    {
	sprintf(error_msg, "light atom type is '%c', must be '%c'",
					light->atom_type, HYDROGEN);
	return  ERROR;
    }

    CHECK_STATUS(find_atom_type(heavy->atom_name, &(heavy->atom_type), error_msg));

    if (heavy->atom_type == HYDROGEN)
    {
	sprintf(error_msg, "heavy atom type must not be '%c'", HYDROGEN);
	return  ERROR;
    }

    return  OK;
}

Status read_shift_file(FILE *fp, int *p_nshifts, Shift ***p_shifts,
							String error_msg)
{
    Long_line line;
    String msg;

    printf("reading shift file\n");

    sprintf(error_msg, "shift file: ");
    error_msg += strlen(error_msg);

    fgets(line, LONG_LINE_SIZE, fp);  /* header */
    fgets(line, LONG_LINE_SIZE, fp);  /* header */

    for (nshifts = 0; fgets(line, LONG_LINE_SIZE, fp) && !empty_string(line) ;
								nshifts++)
    {
	if (!(nshifts % 100))
	    printf("\t...record %d\n", nshifts);

	sprintf(error_msg, "record %d: ", nshifts);
	msg = error_msg + strlen(error_msg);

	CHECK_STATUS(alloc_shift_memory(msg));

	CHECK_STATUS(parse_shift(shifts[nshifts], line, msg));
    }

    *p_nshifts = nshifts;
    *p_shifts = shifts;

    printf("\tfound %d shifts\n", nshifts);

    return  OK;
}
