#include "output.h"

#include "atom.h"
#include "crosspeak.h"

#define  RDB_OUTPUT_COLUMN	0

#define  NILGES_OUTPUT_COLUMN	0

static int ndim;
static int crosspeak_ndim;
static FILE *fp_crosspeak;
static FILE *fp_match;
static FILE **fp_xplor;
static FILE **fp_nilges;
static FILE *fp_null;

static int col1, col2;  /* for Nilges output */

static Bool split_crosspeak_output;

Status init_output(FILE *file_crosspeak, FILE *file_match,
	FILE **file_xplor, FILE **file_nilges, FILE *file_null, int n, int nc,
	Columns *columns, Bool split_output, String error_msg)
{
    int i, c;

    ndim = n;
    crosspeak_ndim = nc;
    fp_crosspeak = file_crosspeak;
    fp_match = file_match;
    fp_xplor = file_xplor;
    fp_nilges = file_nilges;
    fp_null = file_null;
    split_crosspeak_output = split_output;

    col1 = columns[0].data[NILGES_OUTPUT_COLUMN].column;
    col2 = columns[1].data[NILGES_OUTPUT_COLUMN].column;

    if (fp_crosspeak)
    {
/*  this was done when thought all crosspeak files had dim 4
	for (i = 0; i < CROSSPEAK_DIM; i++)
*/
	for (i = 0; i < crosspeak_ndim; i++)
	{
	    c = i + 1;

	    fprintf(fp_crosspeak,
		"resname%d\tresid%d\tatname%d\tatomType%d\tshift%d\t",
							c, c, c, c, c);
	}

	fprintf(fp_crosspeak, "intensity\tspectrum\txpk\tnIntensity");
	fprintf(fp_crosspeak, "\tmatches1\tmatches2\n");

/*  this was done when thought all crosspeak files had dim 4
	for (i = 0; i < CROSSPEAK_DIM; i++)
*/
	for (i = 0; i < crosspeak_ndim; i++)
	    fprintf(fp_crosspeak, "S\tN\tS\tS\tN\t");

	fprintf(fp_crosspeak, "N\tS\tN\tN\tN\tN\n");
    }

    if (fp_match)
    {
	for (i = 0; i < NCOLUMNS; i++)
	{
	    c = columns[i].data[RDB_OUTPUT_COLUMN].column + 1;

	    fprintf(fp_match, "resid%d\tresname%d\tatname%d\t", c, c, c);
	}

	fprintf(fp_match, "nIntensity\txpk\td\n");

	for (i = 0; i < NCOLUMNS; i++)
	    fprintf(fp_match, "N\tS\tS\t");

	fprintf(fp_match, "N\tN\tN\n");
    }

/*  anything?
    if (fp_xplor)
    {
    }

    if (fp_nilges)
    {
    }
*/

    if (fp_null)
	fprintf(fp_null, "peak\tspectrum\n");

    return  OK;
}

static Status print_atom_crosspeak(Atom *atom, String error_msg)
{
    char atom_type[2];
    Line res;

    atom_type[0] = atom->atom_type;
    atom_type[1] = 0;

    if (atom_assigned(atom))
	sprintf(res, "%d%s", atom->residue, atom->chain);
    else
	*res = 0;

    fprintf(fp_crosspeak, "%s\t%s\t%s\t%s\t%4.3f\t",
		atom->res_name, res, atom->atom_name, atom_type, atom->shift);

    return  OK;
}

static Status output_crosspeak(int *nmatches, Crosspeak *crosspeak,
							String error_msg)
{
    int i;

/*  this was done when thought all crosspeak files had dim 4
    for (i = 0; i < CROSSPEAK_DIM; i++)
*/
    for (i = 0; i < crosspeak_ndim; i++)
	print_atom_crosspeak(crosspeak->atom+i, error_msg);

    fprintf(fp_crosspeak, "%3.2f\t%s\t%d\t%4.3f\t%d\t%d\n",
		crosspeak->data.intensity_unscaled, crosspeak->data.spectrum,
		crosspeak->data.number, crosspeak->data.intensity,
		nmatches[0], nmatches[1]);

    return  OK;
}

static Status print_atom_match(Atom *atom, String error_msg)
{
    fprintf(fp_match, "%d%s\t%s\t%s\t",
		atom->residue, atom->chain, atom->res_name, atom->atom_name);

    return  OK;
}

static Status output_match(int *nmatches, Atom ***matches,
				Crosspeak_data *crosspeak, String error_msg)
{
    int i, j;

    for (i = 0; i < nmatches[0]; i++)
    {
	if ((i > 0) && same_atom(matches[0][i-1], matches[0][i]))
	    continue;  /* repeated atom */

	for (j = 0; j < nmatches[1]; j++)
	{
	    if ((j > 0) && same_atom(matches[1][j-1], matches[1][j]))
		continue;  /* repeated atom */

	    CHECK_STATUS(print_atom_match(matches[0][i], error_msg));
	    CHECK_STATUS(print_atom_match(matches[1][j], error_msg));

	    fprintf(fp_match, "%4.3f\t%d\t%2.1f\n", crosspeak->intensity,
				crosspeak->number, crosspeak->distance);
	}
    }

    return  OK;
}

static Status print_atom_xplor(FILE *fp, Atom *atom, String error_msg)
{
    fprintf(fp, "resid %d%s and name %s",
		atom->residue, atom->chain, atom->atom_name);

    return  OK;
}

static Status output_xplor(FILE *fp, int *nmatches, Atom ***matches,
				Crosspeak *crosspeak, String error_msg)
{
    int i;
    Line res;

    fprintf(fp, "!%d\t%2.1f\t%4.3f\t%s\t%4.3f",
		crosspeak->data.number, crosspeak->data.distance,
		crosspeak->data.intensity, crosspeak->data.spectrum,
		crosspeak->data.intensity_unscaled);

/*  this was done when thought all crosspeak files had dim 4
    for (i = 0; i < CROSSPEAK_DIM; i++)
*/
    for (i = 0; i < ndim; i++)
    {
	if (atom_assigned(crosspeak->atom+i))
	    sprintf(res, "%d%s",
		crosspeak->atom[i].residue, crosspeak->atom[i].chain);
	else
	    *res = 0;

	fprintf(fp, "\t%s\t%s\t%s\t%c\t%4.3f",
		crosspeak->atom[i].res_name, res,
		crosspeak->atom[i].atom_name, crosspeak->atom[i].atom_type,
		crosspeak->atom[i].shift);
    }

    fprintf(fp, "\nassign ( ");

    for (i = 0; i < nmatches[0]; i++)
    {
	if ((i > 0) && same_atom(matches[0][i-1], matches[0][i]))
	    continue;  /* repeated atom */

	if (i > 0)
	    fprintf(fp, " or ");

	CHECK_STATUS(print_atom_xplor(fp, matches[0][i], error_msg));

	fprintf(fp, "\n\t");
    }

    fprintf(fp, " )\n");
    fprintf(fp, "       ( ");

    for (i = 0; i < nmatches[1]; i++)
    {
	if ((i > 0) && same_atom(matches[1][i-1], matches[1][i]))
	    continue;  /* repeated atom */

	if (i > 0)
	    fprintf(fp, " or ");

	CHECK_STATUS(print_atom_xplor(fp, matches[1][i], error_msg));

	fprintf(fp, "\n\t");
    }

    fprintf(fp, " ) %2.1f %2.1f %2.1f\n\n",
			crosspeak->data.distance,
			crosspeak->data.distance_minus,
			crosspeak->data.distance_plus);

    return  OK;
}

static Status print_atom_nilges(FILE *fp, Atom *atom, String error_msg)
{
    fprintf(fp, "resid %d%s and name %s",
		atom->residue, atom->chain, atom->atom_name);

    return  OK;
}

static Status output_nilges(FILE *fp, int *nmatches, Atom ***matches,
				Crosspeak *crosspeak, String error_msg)
{
    int i;

    fprintf(fp, "assign ( ");

    for (i = 0; i < nmatches[0]; i++)
    {
	if ((i > 0) && same_atom(matches[0][i-1], matches[0][i]))
	    continue;  /* repeated atom */

	if (i > 0)
	    fprintf(fp, " or ");

	CHECK_STATUS(print_atom_nilges(fp, matches[0][i], error_msg));

	fprintf(fp, "\n\t");
    }

    fprintf(fp, " )\n");
    fprintf(fp, "       ( ");

    for (i = 0; i < nmatches[1]; i++)
    {
	if ((i > 0) && same_atom(matches[1][i-1], matches[1][i]))
	    continue;  /* repeated atom */

	if (i > 0)
	    fprintf(fp, " or ");

	CHECK_STATUS(print_atom_nilges(fp, matches[1][i], error_msg));

	fprintf(fp, "\n\t");
    }

    fprintf(fp,
	" ) %2.1f %2.1f %2.1f volume=%4.3f peak=%d ppm1=%4.3f ppm2=%4.3f\n\n",
		crosspeak->data.distance, crosspeak->data.distance_minus,
		crosspeak->data.distance_plus,
		crosspeak->data.intensity, crosspeak->data.number,
		crosspeak->atom[col1].shift, crosspeak->atom[col2].shift);

    return  OK;
}

static Bool crosspeak_assigned(Crosspeak *crosspeak)
{
    int i;

    for (i = 0; i < ndim; i++)
    {
	if (!atom_assigned(crosspeak->atom+i))
	    return  FALSE;
    }

    return  TRUE;
}

Status output_matches(int *nmatches, Atom ***matches, Crosspeak *crosspeak,
							String error_msg)
{
    int f;

    if ((nmatches[0] == 0) || (nmatches[1] == 0))
    {
/*
	printf("\tNo match for crosspeak %d\n", crosspeak->data.number);
*/

	if (fp_crosspeak)
	    CHECK_STATUS(output_crosspeak(nmatches, crosspeak, error_msg));
    }
    else
    {
	if (fp_match)
	    CHECK_STATUS(output_match(nmatches, matches, &(crosspeak->data), error_msg));

	if (split_crosspeak_output)
	{
 	    if (crosspeak_assigned(crosspeak))
		f = ASSIGNED_OUTPUT;
	    else
		f = UNASSIGNED_OUTPUT;
	}
	else
	{
	    f = ONE_OUTPUT;
	}

	if (fp_xplor[f])
	    CHECK_STATUS(output_xplor(fp_xplor[f], nmatches, matches, crosspeak, error_msg));
    
	if (fp_nilges[f])
	    CHECK_STATUS(output_nilges(fp_nilges[f], nmatches, matches, crosspeak, error_msg));
    }

    return  OK;
}

Status output_null_match(Crosspeak *crosspeak, String error_msg)
{
    if (fp_null)
	fprintf(fp_null, "%d\t%s\n", crosspeak->data.number,
					crosspeak->data.spectrum);

    return  OK;
}
