/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class UserRoleRule
extends BaseRule {
    private String role;

    public void setRole(String theRole) {
        if (theRole == null) {
            throw new IllegalArgumentException("The role cannot be null.");
        }
        this.role = theRole;
    }

    protected String getRole() {
        return this.role;
    }

    public boolean matches(HttpServletRequest request) {
        return request.isUserInRole(this.getRole());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Target role: ");
        buffer.append(this.getRole());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

