% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{flat}
\alias{flat}
\alias{halfflat}
\alias{dflat}
\alias{rflat}
\alias{dhalfflat}
\alias{rhalfflat}
\title{The Improper Uniform Distribution}
\usage{
dflat(x, log = FALSE)

rflat(n = 1)

dhalfflat(x, log = FALSE)

rhalfflat(n = 1)
}
\arguments{
\item{x}{vector of values.}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations.}
}
\value{
\code{dflat} gives the pseudo-density value of 1, while \code{rflat} and \code{rhalfflat} return \code{NaN},
since one cannot simulate from an improper distribution. Similarly, \code{dhalfflat}
gives a pseudo-density value of 1 when \code{x} is non-negative.
}
\description{
Improper flat distribution for use as a prior distribution in BUGS models
}
\examples{
dflat(1)
}
\seealso{
\link{Distributions} for other standard distributions
}
\author{
Christopher Paciorek
}
