// sitar.h
// $Id: sitar.h,v 1.15 2007/11/14 04:44:23 sendan Exp $
// masashi shimakura

#ifndef _SITAR_H_
  #define _SITAR_H_

// #include"config.h"

  #ifndef _VERSION_H_
     #include "version.h"
  #endif

  #ifndef _NETDB_H
    #include<netdb.h>
  #endif

  #ifndef _PTHREAD_H_
    #include<pthread.h>
  #endif



  // チューニングが必要な場合OS側の調整が必要になるかもしれません。
  // FreeBSD6,7 では vm.pmap.shpgperproc の値を調整してください。


  // プライベートのバッファーを開放しないで使いまわす
  // 指定しない場合はスレッド個別のバッファーを毎回開放する（実験中）
  // これはDefaultの設定ではないです、テスト

  //#define KEEP_MALLOC

  // B_LEN は
  // 同時に動作するブロックの最大数です。
  // ブロックの数はスレッドに対応していますが、時間待ちをするスレッドもあるので、その数も含まれます。
  // あくまで同時に立ち上がるブロックの最大数であり、同時に動作(環視)するスレッドの数ではありません。
  // 通常は128で、メモリーに余裕があれば1024以上でも問題はない。
  // 時間待ちをするスレッドの数を考慮して設定してください。
  // sitar.conf のTHREAD_MAX で設定可能


  #define B_LEN   64
  // パトロール用 #define B_LEN   512


  // L_LEN は
  // 同時に動作(環視)出来るスレッドの数です。B_LENより少ない必要があります。
  // 時間待ちをしていたスレッドが走ってもこの数字は越えません。
  // なので、あまりに少ないと非常にレスポンスが下がります。多すぎても負荷がかかります。
  // 増やす場合、システムの上限値に注意してください。
  // sitar.conf のTHREAD_LEN で設定可能です。


  #define L_LEN    4
  // パトロール用  #define L_LEN    12


  // B_MAX は
  // 一つのブロック内で処理出来る行数
  // もしブロック内の環視数に満たない場合はエラーメールにその旨を伝えます
  // LISTを書く時点でブロック内の環視数を制限するか、
  // いっそ割り切って実際に読み込む環視ファイルの最大行数を指定すれば間違いはないが、大量にメモリーを使います。
  // sitar.conf のTBUF_MAX で設定可能
  // ブロックを細かく分けて、この数字を小さくするとメモリーを節約可能


  #define B_MAX    64
  // パトロール用  #define B_MAX    128


  // B_MID
  // 間欠送信を使うブロックの最大数
  // 充分な数を指定してください。B_LEN と同じがベストですが、減らすことでメモリーの節約が出来ます。
  // sitar.conf のMID_MAXで設定可能

  #define B_MID    64
  // パトロール用  #define B_MID    1240

  // TRACE_LEN
  // 中継情報を記憶するバッファの数
  // sitar.conf のTRACE_LENで設定可能

  #define TRACE_LEN   32

  // L_LENの値の排他処理での待ち時間

  #define SLEEP_TIME 1000000

  // MIDリストファイルの自動生成インターバル

  #define MID_INT 300

  // vvversion.h を編集

  #define CL_VAR "sitar-"VERSION
  #define CONF_PATH "/etc/sitar.conf"

  #define BUF_LEN    1024
  #define BUF_SLEN   512
  #define BUF_DEFLEN 128
  #define BUF_MAX    (1024 * 1024 * 2)

  #define BUF_COM    128
  #define IP_LEN     128

  #define TIME_OUT 60
  #define INT_PLUS 10

// ALGET でファイルを分断する
  #define FILE_LEN 1024

/* print conf */
  #define PRINT_CONF

//  拡張デバッグオプション
//  #define LIFE_DEBUG
//  #define MYPEXEC_DEBUG 
//  #define MUTEX_BUG
//  #define MAIL_MUTEX
//  #define MALLOC_BUG
//  #define FREE_BUG
//  #define SCAN_BUG
//  #define CRON_BUG
//  #define DATA_BUG
//  #define SOCKET_BUG
//  #define SOCKET_SENDBUG
//  #define SOCKET_RECVBUG
//  #define MONITOR_BUG
//  #define TIME_FORMAT_BUG

//  #define FILE_COMP_BUG
//  #define FILE_DEBUG 
//  #define SET_DEBUG
//  #define MYCHMEM_DEBUG
//  #define GETCOM_DEBUG
//  #define CONFIGFILE_DEBUG
//  #define STATFILE_DEBUG
//  #define RESOLV_BUG
//  #define SCAN_PORT_DEBUG
//  #define SNMP_DEBUG
//  #define GETFILE_TIME_DEBUG
//  #define BAT_DEBUG
//  #define MID_BUG
//  #define IN_THREAD

  typedef struct global_data global_data_t;

   struct global_data {
     int cron_onoff;                   // CRON 機能を使う1使わない0
     struct thread_data{
        char ** mutex_name;
        char ** middle_name;
        int tcount;
        int tbufmax;
        int midcount;
        int midint;
        int thread_count;
        int thread_max;
        int * fdstat;
        char * middle_id;
        }td;

     struct my_sock{
        int sk;
        int ls;
        struct addrinfo hints;
//      struct sockaddr_in mygd_addr;
        unsigned int my_addrlen;
        char * ip_addr;                // active 
        char * ip2_addr;               /* active */
        char * port_s;
        char * port2_s;
        int port;
        int port2;
        }ip;

     struct trace{
        int trace_len;
        char *** trace_data;
        char ** trace_name;
        char * uni;
        }tr;

//     struct udpset{
//        int * udpport;
//        }ud;

     struct dns_ip{
        char * dns_name;
        char * dns_name2;
        }di;

     struct set_conf{
        char * chA;           /* active swap */
        }sc;

     struct mail_data{
        char * ch_MailCc;     /* active */
        }smtp;

     struct life_data{
        char onoff;
        }ld;

     struct buff_set{
        char * c_name;        /* active */
//      char * myfile;        /* active swap */
        char * c_info;        /* active */
        int life_int;
        int life_los;
        int my_pid;
        int restart_count;
        int stop_count;
        int break_count;
        int bat_int;
        int bat2_int;
        }bf;

     struct file_path{ 
        char * conf_path;            /* read onlly */
        char * command_path;         /* active */
        char * cron_path;            /* active */
        char * cronfile_filename;    /* active */
        char * cronlist_filename;    /* active */
        char * cronlist_filename_2;  /* active */
//        char * cronlist_filestat;    /* active */
        char * bat_filename;         /* active */
        char * bat_filename_2;       /* active */
//        char * bat_filestat;         /* active */
        char * bat2_filename;        /* active */
        char * bat2_filename_2;      /* active */
        char * bat2_filestat;        /* active */
        char * update_com;           /* active */
        char * midump_filename;
        char * midump_filename_2;
        int list_stat;
        }fi;

     struct scan_data {
        char * swap;                 /* active swap */
        char * scan_all;             /* active swap */
        }sd;

     struct cron_data {
        char * swap;                 /* active swap */
        char * scan_all;             /* active swap */
        }cd;


     };



   typedef struct private_data private_data_t;

   struct private_data{
      struct db_data{
         char * swap;
         char * swap1;
         char * swap2;
         char * server;
         char * username;
         char * passwd;
         char * database;
         int port;
         int timeout;
         }db;
      struct scan_buf{
         int fdno;
         char * swap;             /* active swap */
         char * ch_tool;          /* active swap */
         char * ch_com;           /* active swap */
         char * ch_plai;          /* active swap */
         char * ch_stat;          /* active swap */
         char * ch_prot;          /* active swap */
         char * ch_host;          /* sctive swap */
         char * ch_port;          /* active swap */
         char * ch_port_h;        /* active swap */
         char * ch_port_m;        /* active swap */
         char * ch_timeout;       /* active swap */
         char * ch_timeout_h;     /* active swap */
         char * ch_timeout_m;     /* active swap */
         char * ch_data;          /* active swap */
         char * ch_info;          /* active swap */
         char * ch_free1;         /* active swap */
         char * ch_free2;         /* active swap */
         char * ch_free3;         /* active swap */
         char * ch_free4;         /* active swap */
         char * swap_2;           /* active swap */
         char * scan_all;           /* active swap */
         int port;
         int timeout; 
         int check_stat;
         }sb;
      };

   typedef struct swap_array swap_array_t;

   struct swap_array{
      int main_buf_err; 
      int * buf_err;
      pthread_t  * pt;              // スレッド識別子
      int * count;
      char *** swap_data;           // active swap 
      char ** tmp_data;             // active swap 
      };


typedef struct stred stred_t;

struct stred{
   char back_data[1024];
   char name_data[1024];
   int time;
   int check;
   pthread_t t_ret;
   pthread_t t_chk;
// pthread_mutex_t back_data_mutex;
   };






  #include "./prototype.h"

#endif






