
#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<sys/time.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip_icmp.h>
#include<arpa/inet.h>

#include<sys/stat.h> 
#include<sys/un.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"


// #define ICMP_BUG2

extern global_data_t gd;




/*----------------- SCAN ICMP --------------------*/
char * scan_icmp2(char * url_data, char * backdata, int timeout, int * stat, int coe, char * chid)
{
int resolv_ret;

int send_sk, hlen, i, co, comax, id;
float rtt;
unsigned long resoip;
char send_buff[1024];
char recv_buff[1024];
char ipa2[IP_LEN];
char ipx[BUF_URL];
char * ip_addr = ipx;
char pas[BUF_URL];
char * url_pass = pas;
char * ip_addr2 = ipa2;
char ntp[IP_LEN];
char * ntopbuff = ntp;

float frttt;
float frtt[3];

struct sockaddr_in send_addr;
struct timeval tv;
struct ip *ip;
fd_set select_fd;


frtt[0] = 0.0;
frtt[1] = 0.0;
frtt[2] = 0.0;
frtt[3] = 0.0;
frttt = 0.0;

// http:// とかつけちゃった場合の救済
memset(ip_addr, 0x00, BUF_URL);
memset(url_pass, 0x00, BUF_URL);

urldompass_port(url_data, ip_addr, url_pass, strlen(url_data));


id = strtol(chid, (char **)NULL, 10);

// 初期化
rtt = 0.0;
i = 0;
resolv_ret = 0;

memset((char *)&send_addr, 0, sizeof(struct sockaddr_in));
memset(ipa2, 0x00, IP_LEN);
memset(send_buff, 0x00, 1024);
memset(recv_buff, 0x00, 1024);

send_addr.sin_family = AF_INET;


// 名前解決
resoip = 0;

if(0 == self_memcmp(gd.di.dns_name, "RESOLV")){
   backdata = resolvename_th(backdata, ip_addr, timeout, &resoip);
   }
else{
   backdata = resolvename_sk(backdata, ip_addr, timeout, &resoip, gd.di.dns_name, &resolv_ret, '4');
   if(resolv_ret < 0){
      backdata = resolvename_sk(backdata, ip_addr, DEFAULT_TIMEOUT, &resoip, gd.di.dns_name2, &resolv_ret, '4');
      fprintf(stderr,"RESOLV ERR: DNS name resolution failure <%s> %s\n", ip_addr, backdata);
      }
   }

send_addr.sin_addr.s_addr = resoip;

if(0 == (int)send_addr.sin_addr.s_addr || resoip == (int)NULL){
   backdata = safe_sprintf(backdata,BUF_MAX, "%s %s\n", SOCK_2, ip_addr);
   #ifdef ICMP_BUG2
   printf("ICMP: scan_icmp(0): START %s\n", backdata);
   #endif
   * stat = -1;
   return backdata;
   }

// ip_addr2 = inet_ntoa(send_addr.sin_addr);
ip_addr2 = (char *)inet_ntop(AF_INET, &send_addr.sin_addr, ntopbuff, IP_LEN);

#ifdef ICMP_BUG2
printf("ICMP: scan_icmp(1): ICMP host<%s> ip<%s>\n", ip_addr, ip_addr2);
#endif

// RAW socketの生成
if((send_sk = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX,
    "HOST=%s IP=%s %s", ip_addr, ip_addr2, ICMP_1);
   #ifdef ICMP_BUG2
   printf("ICMP: scan_icmp(2): SOCKET CREATE %s\n", backdata);
   #endif
   * stat = -10;
   return backdata;
   }

// ICMPパケットの生成と送信
make_icmp8_packet((struct icmp *)(long int)send_buff, 72, i, id);



// 3回送信するループ
for(co = 0; co < 3; co++){

   comax = 0;

   // パケットの送信に失敗した場合は終了
   if(sendto(send_sk, (char *)&send_buff, 72, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr)) < 0){
      backdata=safe_sprintf(backdata, BUF_MAX,"HOST=%s IP=%s %s", ip_addr, ip_addr2, ICMP_2);
      #ifdef ICMP_BUG2
      printf("ICMP: scan_icmp(3): %d  SEND RAW SOCKET %s\n", co, backdata);
      #endif
      close(send_sk);
      * stat = -10;
      return backdata;
      }

   // select()の待ち時間をimeout * 1秒に設定
   tv.tv_sec = 0;
   tv.tv_usec = 100000.0 * timeout;   // 1/10 秒
//   tv.tv_usec = 10000.0 * timeout;   // 1/100 秒

   #ifdef ICMP_BUG2
   printf("TIMEOUT=%4.7fms\n", (float)(timeout * coe));
   #endif


   while(1){
      FD_ZERO(&select_fd);
      FD_SET(send_sk, &select_fd);

      // while() の回数の上限
      comax++;
      if(comax > 200){
         backdata=safe_sprintf(backdata,BUF_MAX,"HOST=%s IP=%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
          ip_addr, ip_addr2, frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_01);
         #ifdef ICMP_BUG2
         printf("ICMP: scan_icmp(3-0): %d Whle()loop max. %s\n", co, backdata);
         #endif
         close(send_sk);
         * stat = -10;
         return backdata;
         }

      // select()でtime out をまつ
      // timeoutした場合は終了
      if(select(send_sk + 1, &select_fd, NULL, NULL, &tv) <= 0){
         backdata=safe_sprintf(backdata,BUF_MAX,"HOST=%s IP=%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
          ip_addr, ip_addr2, frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_02);
         #ifdef ICMP_BUG2
         printf("ICMP: scan_icmp(3-1): %d SELCT TIME OUT. %s\n", co, backdata);
         #endif
         close(send_sk);
         * stat = -10;
         return backdata;
         }

      // FDに変化があった場合はrecvする
      // recv()出来ないと終了
      if(recvfrom(send_sk, recv_buff, 1024, 0, NULL, NULL) < 0){
         backdata=safe_sprintf(backdata,BUF_MAX,"HOST=%s IP=%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
          ip_addr, ip_addr2, frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_03);
         #ifdef ICMP_BUG2
         printf("ICMP: scan_icmp(4): %d RECV RAW SOCKET %s\n", co, backdata);
         #endif
         close(send_sk);
         * stat = -10;
         return backdata;
         } 

      // 戻ったパケットを判断
      ip = (struct ip *)(long int)recv_buff;
      hlen = ip->ip_hl << 2;

      // 送信先のIPと戻りパケットのIPが同じ場合だけ
      if(ip->ip_src.s_addr == send_addr.sin_addr.s_addr){

         struct icmp *icmp;
         icmp = (struct icmp *)(long int)(recv_buff + hlen);

         if(id == (int)icmp->icmp_id){



// printf("---scan_icmp2()---SEND_ID=%d ---- RECV_ID = %d\n", id, (int)icmp->icmp_id);


         // ICMP_ECHOREPLY 応答 である場合
         // 戻ったパケットのRTTを判断  RTTの時間は閾値が1の場合に100msec
         if(icmp->icmp_type == ICMP_ECHOREPLY){

            gettimeofday(&tv, (struct timezone *)0);
            tvsub(&tv, (struct timeval *)(icmp->icmp_data));
            frtt[co] = tv.tv_sec * 1000.0 + tv.tv_usec / 1000.0;

            // しきい値を越えてしまった
            if(frtt[co] > (timeout * coe)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
               frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_5);
               #ifdef ICMP_BUG2
               printf("ICMP: scan_icmp(5): %d RECV RAW DATA NG! %s\n", co, backdata);
               #endif
               break;
        //     close(send_sk);
        //     * stat = -1;
        //     return backdata;
               }
            // 時間内に帰ってきた 場合　戻る
            // while()の外に出る正常なカウントにうつる
            else if(frtt[co] <= (timeout * coe)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
               frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_6);
               #ifdef ICMP_BUG2
               printf("ICMP: scan_icmp(6): %s %d RECV RAW DATA OK! %s\n", chid, co, backdata);
               #endif
               break;
               }
            else{
               backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
               frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_03);
               #ifdef ICMP_BUG2
               printf("ICMP: scan_icmp(5): %d RTT err! %s\n", co, backdata);
               #endif
               close(send_sk);
               * stat = -1;
               return backdata;
               }

            }

         // 戻ったパケットがエコー 
         // 要求の場合むししてもどる
         else if(icmp->icmp_type == ICMP_ECHO){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
            (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_04);
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(7): %d RECV RAW type<%d> sendip<%d> inip<%d> %s\n",
              co, icmp->icmp_type, send_addr.sin_addr.s_addr, ip->ip_src.s_addr, backdata);
            #endif
            }

         // 到達出来ないと帰った場合
         // 終了
         else if(icmp->icmp_type == ICMP_UNREACH){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_7);
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            } 

         else if(icmp->icmp_type == ICMP_UNREACH_NET){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_14, "Network Unreachable");
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_HOST){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_14, "Host Unreachable");
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_PROTOCOL){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_14, "Protocol Unreachable");
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_PORT){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_14, "Port Unreachable");
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_NEEDFRAG){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_14, "Fragmentation Needed/DF set");
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_SRCFAIL){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_14, "Source Route failed");
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(8): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else{
            backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
               (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
            frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_05);
            #ifdef ICMP_BUG2
            printf("ICMP: scan_icmp(10): %d RECV RAW %s type<%d>\n", co, backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

            }

         }
      // 送信先のIPと戻りパケットのIPが同じでないのでやりなおし
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,"%s :RTT1=%7.4fms 2=%7.4fms 3=%7.4fms TIMEOUT=%dms %s",
            (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
         frtt[0], frtt[1], frtt[2], (timeout * coe), ICMP_06);
         #ifdef ICMP_BUG2
         printf("ICMP: scan_icmp(11): %d RECV RAW DATA sendip<%d> inip<%d>\n",
           co, send_addr.sin_addr.s_addr, ip->ip_src.s_addr);
         #endif
         }
      }  // while(loop)

   }  // 3 count loop


// 正常に3回過ぎた場合
frttt = (frtt[0] + frtt[1] + frtt[2])/3;


// 3回の平均値がしきい値を越えてしまった
if(frttt > (timeout * coe)){
   backdata=safe_sprintf(backdata,BUF_MAX,":HOST=%s :IP=%s :RTT 1=%7.4fms 2=%7.4fms 3=%7.4fms Average=%7.4fms  %s",
    ip_addr, ip_addr2, frtt[0], frtt[1], frtt[2], frttt, ICMP_5);
   #ifdef ICMP_BUG2
   printf("ICMP: scan_icmp(13): %d RECV RAW DATA NG! %s\n", co, backdata);
   #endif
   close(send_sk);
   * stat = -1;
   return backdata;
   }
else{
   backdata=safe_sprintf(backdata,BUF_MAX,":HOST=%s :IP=%s :RTT 1=%7.4fms 2=%7.4fms 3=%7.4fms Average=%7.4fms  %s",
    ip_addr, ip_addr2, frtt[0], frtt[1], frtt[2], frttt, ICMP_16);
   #ifdef ICMP_BUG2
   printf("ICMP: scan_icmp(12): %s LAST %s\n", chid, backdata);
   #endif
   }

close(send_sk);
* stat = 1;
return backdata;
}

