
#ifndef _ZITHER_H_
  #define _ZITHER_H_

// #include"config.h"

  #ifndef _VERSION_H_
     #include "version.h"
  #endif

  #ifndef _NETDB_H
    #include<netdb.h>
  #endif

  #define CL_VAR "zither-"VERSION

  #define BUF_LEN 256
  #define BUF_DEFLEN 128
  #define BUF_MAX (1024 * 1024 * 2)

  #define BUF_SLEN 128
  #define IP_LEN 128
  #define TIME_LEN 32
  #define LIFE_HI 10
  #define INT_PLUS 10
  #define MAIL_INTERVAL 30

  #define LOGPATH_LEN 256

// ALGET でファイルを分断する
  #define FILE_LEN 1024

// DIF での専用待ち時間、クライアントも同様に設定
  #define DIF_WAIT 120

//  基本的なデバッグの設定
// #define DEBUG 

// 起動時のzitherサーバの設定を出力する設定
  #define PRINT_CONF

// サーバクライアント間の通信ロギングの設定
  #define LOG_OUT

// エラー出力のロギングを行う場合の設定
  #define ERR_OUT

// クライアント再接続にメールを送信しない設定
  #define BIG_WOOD 

//  拡張デバッグ設定
//  #define FILESEND_DEBUG
//  #define AL_DEBUG 
//  #define SOCKET_BUG
//  #define SOCKET_RECVBUG
//  #define SOCKET_SENDBUG
//  #define LIFE_DEBUG
//  #define MAIL_DEBUG_IN 
//  #define MAIL_DEBUG_OUT
//  #define DATA_SIZE
//  #define SET_BUG
//  #define THREAD_BUG
//  #define MAIL_RCPTTO

//  エラーメールに監視管理番号をURL検索させるかどうかの設定
  #define URL_SEARCH

//  PostgreSQL か mysql データベースを利用する設定
  #ifdef MYPG_IN 
    #define POSTGRES_IN 
    #define MYSQL_IN
  #endif


//  PostgreSQL のデバッグを行う場合の設定
  #ifdef POSTGRES_IN 
  // #define POSTGRES_DEBUG 
  #endif

//  mysql データベースのデバッグを行う場合の設定
  #ifdef MYSQL_IN 
  //  #define MYSQL_DEBUG
  #endif

  #define SIG_MAXLEN 10


  pthread_mutex_t err_mutex;
  pthread_mutex_t con_mutex;
  pthread_mutex_t stat_mutex;
  pthread_mutex_t sig_mutex;

  #ifdef POSTGRES_IN 
    pthread_mutex_t pg_mutex;
  #endif

  #ifdef MYSQL_IN 
    pthread_mutex_t mysql_mutex;
  #endif

  #define SOCKMAX 128

  typedef struct mail_data mail_data_t;

  struct mail_data{
     struct sockaddr_in my_maddr;
     int sk;
     char * swap;                   /* active swap */
     char * swap2;                  /* active swap */
     char * server;                 /* active swap */
     char * rcptto;                 /* active swap */ 
     char * cp_time;                /* active swap */
     /* --- */
     char * iserver;                /* active swap */
     char * ifrom;                  /* active swap */
     char * ircptto;                /* active swap */
     char * icc;                    /* active swap */
     char * iuser;                  /* active swap */
     char * ihost;                  /* active swap */
     char * idata;                  /* active swap */
     char * isubject;               /* active swap */
     char * iinfo;                  /* active swap */
     char * bccadd;                 /* active swap */
     char * pri;                    /* active swap */
     };

  typedef struct private_data private_data_t;

  struct private_data{
     char * getdata;                /* active */
     struct {
        char * user;                /* active */
        char * user_org;            /* active */
        char * com;                 /* active */
        char * data;                /* active */
        char * def_user;            /* active */
        char * info;                /* active */
        char * minfo;               /* active */
        char * tinfo;               /* active */
        char * ver;                 /* active */
        int fdno;                   /* active */ 
        } rec;
     struct {
        char * lock_filename;       /* active */
        char * clock_filename;      /* sctive */
        char * bat_filename;        /* active */
        char * scan_filename;       /* active */
        char * conf_filename;       /* active */
        char * stat_filename;       /* active */
        char * cronfile_filename;   /* active */
        char * cronlist_filename;   /* active */
        } file;
     struct {
        char * priority;
        char * server;              /* active */
        char * block;              /* active */
        char * from;                /* active */
        char * rcptto;              /* active */
        char * cc;                  /* active */
        char * rcptto_org;          /* active */
        char * cc_org;              /* active */
        int in_mailonoff;
        } mail;
     struct {
        pthread_t life_t;
        char * swap1;                /* active */
        char * swap2;                /* active swap */
        char * swap3;                /* active swap */
        char * swap4;                /* active */
        char * bat_stat;             /* active */
        char * scan_stat;            /* active */
        char * conf_stat;            /* active */
        char * stat_stat;            /* active */
        char * cronfile_stat;        /* active */
        char * cronlist_stat;        /* active */
        int life_int;
        int life_los;
        int cancel;
        long int * in_life;
        char onoff;
        } life;
     };

  typedef struct global_data global_data_t;

  struct global_data {
    pthread_t * pt;                    // thread 識別子
    char * db_select;                  // どっちのDBを使うのかの選択（でふぉはぽすぐれPGSQL）
    char * on_bcc;                     // 送信する全てのメールのコピーを送信するあどれす。
    int cron_onoff;                    // cron 機能を使う場合は1、使わない場合は0
    struct {
       char * postgres_data;           /* active */
       char * pg_webserver;            /* active */
       int stat;
       int postgres_stat;
       }pg;
    struct {
       char * mysql_server;
       char * mysql_username;
       char * mysql_password;
       char * mysql_db;
       int stat;
       }mysql;

    struct {
       int max_count;
//     long int fdno;
       int * fdstat;
       int * sk;
       int ls;
       char * ip_addr;
       int port;
       struct sockaddr_in my_addr;
       char ** inip_addr;

       // v6 開発の為に追加
       struct sockaddr_storage from;
       struct sockaddr_in * sin;
       struct sockaddr_in6 * sin6;
       int fromlen;

       int smax;
//     long int fdcount;
//     int pt;
       fd_set rfd0;
       fd_set rfd;
       char * chport;
       struct addrinfo hints;
       int ss[SOCKMAX + 10];
       }ms; /* my_sock */
    struct {
       char * conf_path;            /* read onlly */
       char * neg_conf;             /* read onlly */
       char * lock_path;            /* active */
       char * clock_path;           /* active */
       char * file_conf;            /* active */
       char * errlog;               /* active */
       char * connectlog;           /* active */
       int con_fd;
       FILE * con_fp;
       int err_fd;
       FILE * err_fp;
       }fp; /* file_path */
    struct {
       char * ch_MailFrom;          /* active */
       char * ch_MailRcptTo;        /* active */
       char * ch_MailServ;          /* active */
       char * ch_MailCc;            /* active */
       int in_mailonoff;
       }md; /* mail_data */
    struct {
       int life_int;
       int life_los;
       }bs; /* buff_set */
    struct {
       int uid;
       }exid; /* zither exit user id */
    #ifdef SIGNATURE_MODE
    struct {
       char ** sig_data;  // x SIG_MAXLEN
       char * sig_stat;
       char * sig_filename;
       int sig_interval;
       int sig_len;
       }sig; 
    #endif

    };

  #include"prototype.h"

#endif 




 
