
#include<stdio.h>
#include<unistd.h>
#include<sys/wait.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<errno.h>
#include<signal.h>
#include<pthread.h>

#include"sitar.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"
#include<file_comp/file_comp.h>

global_data_t gd;
swap_array_t sa;

char * sitarpid = "/usr/local/zither/lock/sitarctl.pid";
pthread_mutex_t fd_mutex;
pthread_mutex_t mail_mutex;
pthread_mutex_t file1_mutex;
pthread_mutex_t file2_mutex;
pthread_mutex_t file3_mutex;
pthread_mutex_t file4_mutex;
pthread_mutex_t name_mutex;
pthread_mutex_t exec_mutex;
pthread_mutex_t popen_mutex;
pthread_mutex_t fdstat_mutex;
pthread_mutex_t break_mutex;
pthread_mutex_t thread_mutex;


// sitar main関数
int main(int argc, char * argv[])
{
int tret;
pthread_t t1, t2, t3, t4;
errno = 0;

pthread_mutex_init(&fd_mutex, NULL);
pthread_mutex_init(&mail_mutex, NULL);
pthread_mutex_init(&file1_mutex, NULL);
pthread_mutex_init(&file2_mutex, NULL);
pthread_mutex_init(&file3_mutex, NULL);
pthread_mutex_init(&file4_mutex, NULL);
pthread_mutex_init(&name_mutex, NULL);
pthread_mutex_init(&exec_mutex, NULL);
pthread_mutex_init(&popen_mutex, NULL);
pthread_mutex_init(&fdstat_mutex, NULL);
pthread_mutex_init(&break_mutex, NULL);
pthread_mutex_init(&thread_mutex, NULL);

malloc_set();
set_data();
optin(argc, argv);
conf_set(gd.fi.conf_path);
setup_check();
#ifdef PRINT_CONF
print_conf();
#endif
malloc_set2();
swap_malloc_set();

#ifdef KEEP_MALLOC
private_malloc_set();
#endif

// シグナルの設定
signal(SIGINT, signal_exit);
signal(SIGKILL, signal_exit);
signal(SIGQUIT, signal_exit);
signal(SIGHUP, signal_exit);
// signal(SIGTERM, signal_exit);  // BSDの為

gd.bf.my_pid = (int)getpid();

// プロセスIDの設定
 if(setpgid(gd.bf.my_pid, gd.bf.my_pid)){
   fprintf(stderr,"main(): fork stpgid no chenge!");
   } 

// サーバに接続
if((socket_connect(&gd.ip.my_addr, gd.ip.port, gd.ip.ip_addr, &gd.ip.sk)) < 0){
   fprintf(stderr,"main(): Not connection <1> %s %d\n", gd.ip.ip_addr, gd.ip.port);
   sleep(10);
   if((socket_connect(&gd.ip.my_addr, gd.ip.port2, gd.ip.ip2_addr, &gd.ip.sk)) < 0){
      fprintf(stderr,"main(): Not connection <2> %s %d\n", gd.ip.ip2_addr, gd.ip.port2);
      safe_exit("main(): socket connect err exit \n");
      }
   }


// 認証開始
start_neg();
// 固有設定
setup_conf();

gd.bf.stop_count = 0;
gd.bf.break_count = 0;
tret = 0;

// メール完結処理用のバッファーを復元
//pthread_mutex_lock(&name_mutex);
safe_pthread_mutex_lock(&name_mutex);
miname_install();
pthread_mutex_unlock(&name_mutex);


   // 監視スレッド生成
   if((tret = pthread_create( &t1, NULL, (void *)sitar_scan, NULL)) != 0){
      fprintf(stderr,"sitar.c pthread_create(0): %d %d\n",tret, errno);
      }
   // 疎通監視スレッド生成
   if((tret = pthread_create( &t3, NULL, (void *)life_pthread, NULL)) != 0){
      fprintf(stderr,"sitar.c pthread_create(1): %d %d\n",tret, errno);
      }
   // MIDネームリスト自動生成スレッドの生成
   if((tret = pthread_create( &t4, NULL, (void *)th_miname_dump, NULL)) != 0){
      fprintf(stderr,"sitar.c pthread_create(1): %d %d\n",tret, errno);
      }
   // CRONスレッド生成
// if(gd.cron_onoff == 1){
//    if(tret = (pthread_create( &t2, NULL, (void *)sitar_cron, NULL)) != 0){
//       fprintf(stderr,"sitar.c pthread_create(2): %d\n",tret);
//       }
//    }

   pthread_join( t1, NULL);
   pthread_join( t3, NULL);
   pthread_join( t4, NULL);
// if(gd.cron_onoff == 1){
//    pthread_join( t2, NULL);
//    }

// It doesn't reach. (ここに来ることはありません)

swap_malloc_free();
malloc_set2_free();
malloc_set_free();

#ifdef KEEP_MALLOC
private_malloc_free();
#endif

close(gd.ip.sk);
gd.ip.sk = 0;
return 0;
}



