
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include<sys/stat.h>
#include<errno.h>

#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"



/* 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_smtp_connect(int, char *, char *, int);
*/

int set_smrequest(char *);
int check_smrecvdata(char *);


int set_smrequest(char * backdata)
{

sprintf(backdata, "HELO localhost\r\n");
#ifdef SMTP_BUG
printf("SMTP: set_smrequest(): %s", backdata);
#endif

return 0;
}



int check_smrecvdata(char * recvdata)
{
int ret;
int max = 0;

max = (int)strlen(recvdata);

ret = -1;
if(max > 3){
   if(recvdata[0] == '2'){
      ret = 0;
      }
   else {
      ret = -1;
      } 
   }
else{
   ret = -1;
   }

return(ret);
}




/*----------------- SCAN TCP CONNECT --------------------*/
char * scan_smtp_connect(int port, char * url_dom, char * backdata, int timeout, int * pst)
{
int sk, re, ret, retval, dcount, arglen;
unsigned long resoip;
char ipa[IP_LEN];
char * ip_addr = ipa;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;
char recvd[BUF_LEN];
char sendd[BUF_LEN];
char * recvdata = recvd;
char * senddata = sendd;

memset(recvdata, 0x00, BUF_LEN);
memset(senddata, 0x00, BUF_LEN);

// struct buf_data bd;

ret = -1;
errno = 0;
dcount = 0;
arglen = sizeof(int);


if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"scan_smtp URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   backdata=safe_sprintf(backdata, BUF_MAX,
    "URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   * pst = -1;
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);

backdata = resolvename(backdata, url_dom, timeout, &resoip);
my_addr.sin_addr.s_addr = resoip;

if(0 == (int)my_addr.sin_addr.s_addr || resoip == (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s %s %d\n",
    SOCK_2, url_dom, (int)my_addr.sin_addr.s_addr);
   close(sk);
   * pst = -1;
   return backdata;
   }

ip_addr = inet_ntoa(my_addr.sin_addr);

#ifdef SMTP_BUG
printf("SMTP: scan_smtp_connect(0): %s %s %d\n", url_dom, ip_addr, port);
#endif

// 非同期通信に切り替え、コネクション実行
fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long int)&my_addr, sizeof(my_addr));

// 速攻で繋がった場合の処理
if(re >= 0){
  // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);
   backdata=safe_sprintf(backdata,BUF_MAX,
    "SMTP=%s Port=%d %s", url_dom, port, SOCK_5);
   #ifdef SMTP_BUG
   printf("SMTP: scan_url_connect(1): CONNECT SUCCESS %s\n", backdata);
   #endif
   goto notselect;
   }

// errnoが EINPROGRESS な場合
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      // selectのタイムアウト
      if(retval < 0){
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(2): select error BREAK- %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s %s", url_dom, port, SOCK_15, SOCK_5);
         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * pst = -1;
         return backdata;
         }
      else if(retval == 0){
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(3): select timed out BREAK- %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s %s", url_dom, port, SOCK_16, SOCK_5);
         // 非同期から同期に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * pst = -1;
         return backdata;
         }
      // 時間内に接続出来たのLoopOut
      else {
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(4): select time succes BREAK- %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         break;
         }
      }

   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);

   // select を省いたGOTO
   notselect :;



   // ソケットに関するペンディングエラーを戻す
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      backdata=safe_sprintf(backdata,BUF_MAX,
       "URL=%s Port=%d %s", url_dom, port, SOCK_13);
      #ifdef SMTP_BUG
      fprintf(stderr,"getsockopt(5) Errors!\n");
      #endif
      close(sk);
      * pst = -1;
      return backdata;
      }
   else{
     // エラーがある
      if(retval){
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(6): 1 SO_ERROR %d -\n", retval);
         #endif
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d Error! %s", url_dom, port, SOCK_5);
         close(sk);
         * pst = -1;
         return backdata;
         }
      // エラーが無い場合は、ステータスの確認にうつります
      else{
        // とりあえず、SMTPからの200番の返事をまちます

         // 再度非同期通信の開始
         fcntl(sk, F_SETFL, O_NONBLOCK);

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);
            // select 異常終了
            if(retval < 0){
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(7): retval 0 ERR ===\n");
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s %s", url_dom, port, SOCK_15, SMTP_22);
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = -1;
               return backdata;
               }
            // select のタイムアウト
            else if(retval == 0){
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(8): retval 1 ERR\n"); 
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s %s", url_dom, port, SOCK_16, SMTP_33);
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = -1;
               return backdata;
               }
            else{

               // fdに変化があったので読んでみたりするテスト
               dcount = recv(sk, recvdata, BUF_LEN, 0);

               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(9): recv-- %s --\n", recvdata);
               #endif
               // 受信量が異常
               if(dcount < 1){
                  backdata = safe_sprintf(backdata,BUF_MAX,
                   "URL=%s Port=%d %s"
                   , url_dom, port, SMTP_22);
                  ret = -1;
                  }
               // 受信量は正常
               else{
                  ch_char(recvdata, senddata);
                  swap_mem(senddata, '\n', ' ');
                  swap_mem(senddata, ',', ' ');

                  ret = check_smrecvdata(recvdata);
                  // 受信ステータスが200番だいでない
                  if(ret < 0){
                     backdata = safe_sprintf(backdata, BUF_MAX,"%s <%s>\n", SMTP_11, senddata);
                     #ifdef SMTP_BUG
                     printf("SMTP: scan_smtp_bug(10): ret<%d><%d> recvdata<%s> backdata<%s>\n",
                       ret,*pst, recvdata, backdata);
                     #endif
                     // 非同期通信から同期通信に
                     fcntl(sk, F_SETFL, 0);
                     close(sk);
                     * pst = ret;
                     return backdata;
                     }
                  // 受信ステータスが200番だいです。
                  else{
                     backdata = safe_sprintf(backdata, BUF_MAX,"%s <%s>\n", SMTP_44, senddata);
                     #ifdef SMTP_BUG
                     printf("SMTP: scan_smtp_bug(11): ret<%d><%d> recvdata<%s> backdata<%s>\n",
                       ret,*pst, recvdata, backdata);
                     #endif
                     // 非同期通信から同期通信に
                     fcntl(sk, F_SETFL, 0);
                     break;
                     }
                  }
               }  // select()
            }  // while()

         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         dcount = 0;





         //  SMTPから返事があったので、HELOを送ってステータスをまちます
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         set_smrequest(senddata);
         #ifdef SMTP_BUG
         printf("SMTP: scan_smtp_connect(12): set_request*send-- %s --\n", senddata);
         #endif 

         // 再度非同期通信の開始
         fcntl(sk, F_SETFL, O_NONBLOCK);

         // hello localhost の送信
         send(sk, senddata, strlen(senddata), 0);

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);
            // select 異常終了
            if(retval < 0){
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(13): retval 0 ERR ===\n");
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s %s", url_dom, port, SOCK_15, SMTP_2);
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = -1;
               return backdata;
               }
            // select のタイムアウト
            else if(retval == 0){
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(14): retval 1 ERR\n"); 
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s %s", url_dom, port, SOCK_16, SMTP_3);
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = -1;
               return backdata;
               }
            else{
               dcount = recv(sk, recvdata, BUF_LEN, 0);
               #ifdef SMTP_BUG
               printf("SMTP: scan_smtp_connect(15): recv-- %s --\n", recvdata);
               #endif
               // 受信量が異常
               if(dcount < 1){
                  backdata = safe_sprintf(backdata,BUF_MAX,
                   "URL=%s Port=%d %s"
                   , url_dom, port, SMTP_2);
                  ret = -1;
                  }
               // 受信量は正常
               else{
                  ch_char(recvdata, senddata);
                  swap_mem(senddata, '\n', ' ');
                  swap_mem(senddata, ',', ' ');

                  ret = check_smrecvdata(recvdata);
                  // 受信ステータスが200番だいでない
                  if(ret < 0){
                     backdata = safe_sprintf(backdata, BUF_MAX,"%s <%s>\n", SMTP_1, senddata);
                     #ifdef SMTP_BUG
                     printf("SMTP: scan_smtp_bug(16): <2> ret<%d><%d> recvdata<%s> backdata<%s>\n",
                       ret,*pst, recvdata, backdata);
                     #endif
                     }
                  // 受信ステータスが200番だいです。
                  else{
                     backdata = safe_sprintf(backdata, BUF_MAX,"%s <%s>\n", SMTP_4, senddata);
                     #ifdef SMTP_BUG
                     printf("SMTP: scan_smtp_bug(17): <2> ret<%d><%d> recvdata<%s> backdata<%s>\n",
                       ret,*pst, recvdata, backdata);
                     #endif
                     }
                  }
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               close(sk);
               * pst = ret;
               return backdata;
               }
            }  // while()



         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * pst = ret;
         return backdata;
         }
      }
   }

// 非同期通信から同期通信に
fcntl(sk, F_SETFL, 0);
backdata=safe_sprintf(backdata,BUF_MAX,
 "URL=%s Port=%d %s", url_dom, port, SOCK_14);

close(sk);
* pst = -1;

return backdata;

}




