#include<arpa/inet.h>
#include<almemsys/almemsys.h>



// FOR RES 用、指定時間内なら実行
int floop(int year_ab, int month_ab, int day_ab, int hour_ab, int min_ab,
          int year_ob, int month_ob, int day_ob, int hour_ob, int min_ob)
{
int year_a, month_a, day_a, hour_a, min_a;
int year_o, month_o, day_o, hour_o, min_o;
int ret, rytime, rmotime, rdtime, rtime, rmtime;
time_t u_start;
time_t u_stop;
time_t u_present;
ret = -1;

rytime = ctime_getr('y');            // 現在の年をryimeに代入 
rmotime = ctime_getr('m');           // 現在の月をrmotimeに代入 
rdtime = ctime_getr('d');            // 現在の日をrdimeに代入 
rtime = ctime_getr('h');             // 現在の時間をrtimeに代入 
rmtime = ctime_getr('i');            // 現在の分をrmtimeに代入 

// 年　をフォーマット(2020年)
if(year_ab == 100){ year_a = rytime; }
else if(year_ab >= 2020){ year_a = 2020; }
else if(year_ab <= 2008){ year_a = 2008; }
else { year_a = year_ab; }

if(year_ob == 100){ year_o = rytime; }
else if(year_ob >= 2020){ year_o = 2020; }
else if(year_ob <= 2008){ year_o = 2008; }
else { year_o = year_ob; }

// 月 12以上を12に、0以下を1に整理
if(month_ab == 100){ month_a = rmotime; }
else if(month_ab >= 12){ month_a = 12; }
else if(month_ab <= 0){ month_a = 1; }
else { month_a = month_ab; }

if(month_ob == 100){ month_o = rmotime; }
else if(month_ob >= 12){ month_o = 12; }
else if(month_ob <= 0){ month_o = 1; }
else { month_o = month_ob; }

// 日 31以上を31に、0以下を1に整理
if(day_ab == 100){ day_a = rdtime; }
else if(day_ab >= 31){ day_a = 31; }
else if(day_ab <= 0){ day_a = 1; }
else { day_a = day_ab; }

if(day_ob == 100){ day_o = rdtime; }
else if(day_ob >= 31){ day_o = 31; }
else if(day_ob <= 0){ day_o = 1; }
else{ day_o = day_ob; }

// 時間 24 を0に整理
if(hour_ab == 100){ hour_a = rtime; }
else if(hour_ab >= 24){ hour_a = 0; }
else if(hour_ab <= 0){ hour_a = 0; }
else { hour_a = hour_ab; }

if(hour_ob == 100){ hour_o = rtime; }
else if(hour_ob >= 24){ hour_o = 0; }
else if(hour_ob <= 0){ hour_o = 0; }
else{ hour_o = hour_ob; }

// 分 60を60に整理
if(min_ab == 100){ min_a = rmtime; }
else if(min_ab >= 60){ min_a = 60; }
else if(min_ab <= 0){ min_a = 0; }
else{ min_a = min_ab; }

if(min_ob == 100){ min_o = rmtime; }
else if(min_ob >= 60){ min_o = 60; }
else if(min_ob <= 0){ min_o = 0; }
else{ min_o = min_ob; }

// 開始UNIX時間を得る
u_start = get_unixtime(
        year_a,
        month_a,
        day_a,
        hour_a,
        min_a,
        0);
// 停止UNIX時間を得る
u_stop = get_unixtime(
        year_o,
        month_o,
        day_o,
        hour_o,
        min_o,
        0);
// 現在のUNIX時間を得る
u_present = time(NULL);


#ifdef MUTEX_BUG
printf("MUTEX: floop(): FOR RES 開始年=%d, 開始月=%d, 開始日=%d, 開始時=%d, 開始分=%d, 開始UNIX=%ld\n", 
        year_a,
        month_a,
        day_a,
        hour_a,
        min_a,
        u_start);
printf("MUTEX: floop(): FOR RES 終了年=%d, 終了月=%d, 終了日=%d, 終了時=%d, 終了分=%d, 終了UNIX=%ld\n", 
        year_o,
        month_o,
        day_o,
        hour_o,
        min_o,
        u_stop);
printf("MUTEX: floop(): FOR RES 現在年=%d, 現在月=%d, 現在日=%d, 現在時=%d, 現在分=%d 現在UNIX=%ld\n", 
        rytime,
        rmotime,
        rdtime,
        rtime,
        rmtime,
        u_present);
#endif


// 時間の比較
if(u_stop <= u_start){
   #ifdef MUTEX_BUG
   printf("MUTEX: f_loop(): FOR RES 開始停止が等しいか停止が開始より早い. \n");
   #endif
   ret = -1;
   }
else if(u_present < u_start){
   #ifdef MUTEX_BUG
   printf("MUTEX: f_loop(): FOR RES 開始時間に達してない. \n");
   #endif
   ret = -1;
   }
else if(u_present > u_stop){
   #ifdef MUTEX_BUG
   printf("MUTEX: f_loop(): FOR RES 停止時間を過ぎている. \n");
   #endif
   ret = -1;
   }
else{
   ret = 1;
   }


// 状況表示 
if(ret == 1){
   #ifdef MUTEX_BUG
   printf("MUTEX: floop(): FOR RES の条件を満たしました  ret = <%d>\n", ret);
   #endif 
   }
else{
   #ifdef MUTEX_BUG
   printf("MUTEX: floop(): FOR RES の条件を満たしていません  ret = <%d>\n", ret);
   #endif 
   }
  
return ret;
}









