// times.c
// $Id: times.c,v 1.2 2007/11/13 11:45:17 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<time.h>
#include<arpa/inet.h>
#include<pthread.h>

#include"sitar.h"
#include"almemsys.h"

/*
int time_getr(char [], int);
long int u_time(void);
int mail_time_getr(char [], int, char *);
long int ctime_getr(char);
*/


char * char_wday(int);
char * char_mon(int);
int time_minus(int, int, char);
int m_sec(int);
int ch_time_munus(int, int, int);
int floop_h(int, int, int);

extern struct buff_set bf;





int hloop(int hour, int min, int mmin)
{
int mt, da;     // hour 時間
int mtm, dam;   // min 分
int msc;
int ret;

// hour 24を0に整理
if(hour >= 24){ hour = 0; }
if(hour <= 0){ hour = 0; }
// min 60を0に整理
if(min >= 60){ min = 0; }
if(min <= 0){ min = 0; }

ret = -1;

// sitarの監視インターバル秒から分を出す。
msc = m_sec(mmin);

da  = ctime_getr('h');              // da に今の時間をわたす
dam = ctime_getr('i');              // dam に今の分をわたす

mtm = time_minus(min, msc, 'i');      // min の一分前の時間をmtmにわたす
if((min - msc) < 0){
   mt = time_minus(hour, 1, 'h');   // mtmが60で反転してる場合hourの一時間前の時間をmtにわたす
   }
else{
   mt = hour;
   }

#ifdef MUTEX_BUG
printf("MUTEX: hloop(): 時間の設定値 設定時=%d, 設定分=%d, 現在時=%d, 現在分=%d, 実行時=%d, 実行分=%d -分=%d\n",
        hour, min, da, dam, mt, mtm, msc);
#endif

if(da == mt && 0 == ch_time_munus(dam, min, msc)){
   #ifdef MUTEX_BUG
   printf("MUTEX: hloop(): JUST の条件を満たしたので、LOOPに入ります %d == %d 実行まで %d 分間お待ちください\n", mt, da, msc);
   #endif 
   while(1){
      sleep(10);
      #ifdef MUTEX_BUG
      printf("MUTEX: hloop(): JUST監視　実時間 <%d> 設定時間 <%d> 設定分 <%d>\n", ctime_getr('h'), hour, min);
      #endif 
      if(hour == ctime_getr('h') && min == ctime_getr('i')){
         #ifdef MUTEX_BUG
         printf("MUTEX: hloop(): JUST の条件を満たしたLOOPから正常に抜けます、監視は実行されます %d == %d && %d == %d\n", mt, da, mtm, dam);
         #endif 
         ret = 1;
         break;
         }
      }
   }

return ret;
}




// 秒を分に変える関数、60以下は1になる。あまりが30より大きいと1＋
int m_sec(int sec)
{
int min;

if(sec <= 60){
   min = 1;
   }
else{
   min = sec / 60;
   if(30 <= sec % 60){
      min = min + 1;
      }
   }

return min;
}




// 現在の分で閾値に入っているか確認し、よければ0を返す。
int ch_time_munus(int dam, int min, int msc)
{
int ret, co, uu;
ret = -1;
uu = 0;

for(co = 0; co < msc; co++){
   uu = time_minus(min, co, 'i');
   #ifdef MUTEX_BUG
   printf("MUTEX: ch_time_munus(1): %d =? %d\n", dam, uu);
   #endif
   if(dam == uu){
      ret = 0;
      #ifdef MUTEX_BUG
      printf("MUTEX: ch_time_munus(2): %d == %d ret=%d\n", dam, uu, ret);
      #endif
      break;
      }
   }

return ret;
}





int floop(int sta, int msta, int sto, int msto)
{
int ret, stat, rtime, rmtime;
ret = -1;
stat = 0;

rtime = ctime_getr('h');             // 現在の時間をrtimeに代入 
rmtime = ctime_getr('i');            // 現在の分をrmtimeに代入 

// 時間 24 を0に整理
if(sta >= 24){ sta = 0; }
if(sta <= 0){ sta = 0; }
if(sto >= 24){ sto = 0; }
if(sto <= 0){ sto = 0; }
// 分 60を60に整理
if(msta >= 60){ msta = 60; }
if(msta <= 0){ msta = 0; }
if(msto >= 60){ msto = 60; }
if(msto <= 0){ msto = 0; }

#ifdef MUTEX_BUG
printf("MUTEX: floop(): FOR 開始時=%d, 開始分=%d, 終了時=%d, 終了分=%d, 現在時=%d, 現在分=%d\n", 
        sta,
        msta, 
        sto,
        msto,
        rtime,
        rmtime );
#endif

ret = floop_h(sta, sto, rtime);  // 現在の時間が始まり時間と終わり時間の中に入っていれば1を、なければ-1を返す。

if(ret == 1){

   if(sta != sto){                 // 開始時刻と停止時刻が等しくない場合
      if(sta == rtime){            // 開始時刻と現在時刻が同じとき
         if(msta <= rmtime){       // 開始分と現在分が同じか、現在分のほうが大きい場合
            ret = 1;               // GO
            }
         else{
            ret = -1;              // STOP
            }
         }
      else if(sto == rtime){       // 終了時刻と現在時刻が同じとき
         if(msto <= rmtime){       // 終了分と現在分が同じか、現在分が大きい場合
            ret = -1;              // STOP
            }
         else{
            ret = 1;               // GO
            }
         }
      else{
         ret = 1;                  // GO
         }
      }
   else{                           // 開始時刻と停止時刻が等しい場合
      if(sta == rtime){            // 開始時刻&停止時刻と現在時刻が同じとき
         if(msta <= rmtime && msto >= rmtime){ // 開始分と現在分が同じか、現在分のほうが大きいかつ、停止分と現在分が等しいか小さい
            ret = 1;               // GO
            }
         else{
            ret = -1;              // STOP
            }
         }
      else{
         ret = -1;                 // STOP
         }
      }
   }

  
if(ret == 1){
   #ifdef MUTEX_BUG
   printf("MUTEX: floop(): FOR の条件を満たしました  ret = <%d>\n", ret);
   #endif 
   }
else{
   #ifdef MUTEX_BUG
   printf("MUTEX: floop(): FOR の条件を満たしていません  ret = <%d>\n", ret);
   #endif 
   }
  
return ret;
}





int floop_h(int sta, int sto, int rtime)
{
int ret, count, stat;
ret = -1;
stat = 0;

if(sta == 0 && sto >= 0){
   for(count = 0; count <= sto; count++){
      if(count == 24){ stat = 0; }
      else { stat = count; }
      if(rtime == stat){ ret = 1; }
      #ifdef MUTEX_BUG
      printf("MUTEX: floop(): select time 1 <%d>\n", stat);
      #endif
      }
   }
else if(sta > 0 && sto == 0){
   for(count = sta; count <= 24; count++){
      if(count == 24){ stat = 0; }
      else { stat = count; }
      if(rtime == stat){ ret = 1; }
      #ifdef MUTEX_BUG
      printf("MUTEX: floop(): select time 2 <%d>\n", stat);
      #endif
      }
   }
else if(sta > 0 && sto >= sta){
   for(count = sta; count <= sto; count++){
      if(count == 24){ stat = 0; }
      else { stat = count; }
      if(rtime == stat){ ret = 1; }
      #ifdef MUTEX_BUG
      printf("MUTEX: floop(): select time 3 <%d>\n", stat);
      #endif
      }
   }
else if(sta > 0 && sto < sta){
   for(count = sta; count < 24; count++){
      if(count == 24){ stat = 0; }
      else { stat = count; }
      if(rtime == stat){ ret = 1; }
      #ifdef MUTEX_BUG
      printf("MUTEX: floop(): select time 4 <%d>\n", stat);
      #endif
      }
   for(count = 0; count <= sto; count++){
      if(count == 24){ stat = 0; }
      else { stat = count; }
      if(rtime == stat){ ret = 1; }
      #ifdef MUTEX_BUG
      printf("MUTEX: floop(): select time 5 <%d>\n", stat);
      #endif
      }
   }

return ret;
}




// 24時間せいで、t 時 から mt 時間引いた時間を返す関数
int time_minus(int t, int mt, char cha)
{
int an, minu;
an = 0;
minu = 0;

switch(cha){
   case 'h': minu = 24;
             break;
   case 'i': minu = 60;
             break;
   default : minu = 12;
             break;
   }

if(t >= minu){ t = 0; }
if(t <= 0){ t = 0; }
if(mt >= minu){ mt = 0; }
if(mt <= 0){ mt = 0; }

if(t == 0 && mt <= minu){ an = minu - mt; }
else if(t > 0 && mt <= t){ an = t - mt; }
else if(t > 0 && mt > t){ an = minu - (mt - t); }

if(an == minu){ an = 0; }

return an;
}






/* ------------ mail_time_getr --------------- */
int mail_time_getr(char buf[], int count, char * zone)
{
time_t t;
struct tm tmbuf;

t = time(NULL);
localtime_r(&t, &tmbuf);

if(20<=count){
   sprintf(buf,"%s, %02d %s %04d %02d:%02d:%02d %s",
      (char *)char_wday(tmbuf.tm_wday),
      tmbuf.tm_mday,
      (char *)char_mon(tmbuf.tm_mon),
      tmbuf.tm_year + 1900,
      tmbuf.tm_hour,
      tmbuf.tm_min,
      tmbuf.tm_sec,
      zone);
   }
return 0;
}






char * char_wday(int wday)
{
char * ret;
switch(wday){
    case 0 : ret = "Sun"; break;
    case 1 : ret = "Mon"; break;
    case 2 : ret = "Tue"; break;
    case 3 : ret = "Wed"; break;
    case 4 : ret = "Thu"; break;
    case 5 : ret = "Fri"; break;
    case 6 : ret = "Sat"; break;
    default : ret = "Not!"; break;
    }
return(ret);
}


char * char_mon(int mon)
{
char * ret;
switch(mon){
    case 0 : ret = "Jan"; break;
    case 1 : ret = "Feb"; break;
    case 2 : ret = "Mar"; break;
    case 3 : ret = "Apr"; break;
    case 4 : ret = "May"; break;
    case 5 : ret = "Jun"; break;
    case 6 : ret = "Jul"; break;
    case 7 : ret = "Aug"; break;
    case 8 : ret = "Sep"; break;
    case 9 : ret = "Oct"; break;
    case 10 : ret = "Nov"; break;
    case 11 : ret = "Dec"; break;
    default : ret = "Not!"; break;
    }
return(ret);
}




/* ------------ time_getr --------------- */
int time_getr(char buf[], int count)
{
time_t t;
struct tm tmbuf;

t = time(NULL);
localtime_r(&t, &tmbuf);

if(20<=count){
   sprintf(buf,"%04d:%02d:%02d:%02d:%02d:%02d",
      tmbuf.tm_year + 1900,
      tmbuf.tm_mon + 1,
      tmbuf.tm_mday,
      tmbuf.tm_hour,
      tmbuf.tm_min,
      tmbuf.tm_sec);
   }
return 0;
}




/* -------------- u_time --------------- */
long int u_time(void)
{
time_t tt;
tt = time(NULL);
return((long int)tt);
}



/* ------------ 指定キャラから今の時間日付等を返す (thread safe) --------------- */
int ctime_getr(char ch)
{
time_t t;
struct tm tmbuf;

t = time(NULL);
localtime_r(&t, &tmbuf);

switch(ch){
  case 'y': return(tmbuf.tm_year + 1900);
  case 'm': return(tmbuf.tm_mon + 1);
  case 'd': return(tmbuf.tm_mday);
  case 'h': return(tmbuf.tm_hour);
  case 'i': return(tmbuf.tm_min);
  case 's': return(tmbuf.tm_sec);
  default : break;
  }

return -1;
}


