// snmp_test.c
// $Id: snmp_test.c,v 1.3 2007/10/02 10:22:12 sendan Exp $
// masashi shimakura

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <string.h>

#include "almemsys.h"
#include "jpreturn.h"

#define MIB_BUFLEN 1024

/*
char * snmp_test(char *, char *, char *, char *, int *, int);


int main(int argc, char ** argv)
{
int stat = 0;

char * getdata = (char *)calloc(BUF_LEN, sizeof(char));

printf("%s\n", snmp_test(getdata, argv[1], argv[2], argv[3], &stat, 2, 6));

free(getdata);
return(0);
}
*/



/* snmp_test() is get oid value                               */
/* 0:outdatabuf 1:objname 2:host or IP 3:send OID 4:return status(0>error) 5:out put option 0,1,2 */
/* opt = 0 -> true opt > 0 ->format checkd */
/* chk is returnd fomat check status. */
char * snmp_test(char * data, char * name, char * host, char * getoid, int * stat, int opt, int * chk, int timeout)
{
int ret;
char * buf;
char * tmp;
struct snmp_session session, *ss;
struct snmp_pdu *pdu;
struct snmp_pdu *response;

struct tree    *tp;

ret = 0;

oid anOID[MAX_OID_LEN];
size_t anOID_len = MAX_OID_LEN;

struct variable_list *vars;
int status;

/* init buf */
buf = (char *)calloc(MIB_BUFLEN, sizeof(char));
data = safe_memcpy(data, "Not data Not use bufer!\n", BUF_MAX);

/* init snmp lib */
init_snmp("sitar_snmp");

/* init session */
snmp_sess_init(&session);
session.peername = strdup(host);

// session.timeout = 10000000L;  // 10
if(timeout <= 0){
   timeout = 1;
   }
else if(timeout > 20){
   timeout = 20;
   }

#ifdef SNMP_DEBUG
printf("-----timeout %d sec \n", timeout);
#endif

// session.timeout = 20000000L; // 20 秒
session.timeout = (long)(1000000 * timeout);
session.retries = 0;

/* snmp version set.  not support vr3  */
session.version = SNMP_VERSION_1;
session.community = name;
session.community_len = (int)strlen((char *)session.community);

/* open session */
ss = snmp_open(&session);

#ifdef SNMP_DEBUG
printf("snmp_test(): --SESSION LOCL PEER NO-- %s\n", session.peername);
printf("snmp_test(): --SESSION TIMEOUT   NO-- %ld\n", session.timeout);
printf("snmp_test(): --SESSION retries   NO-- %d\n", session.retries);
#endif


if(!ss){
   snmp_perror("ack");
   snmp_log(LOG_ERR, "snmp session not open.\n");
   data = safe_sprintf(data, BUF_MAX,"%s %s %s\n", SNMP_25, host, getoid);
   #ifdef SNMP_DEBUG
   fprintf(stderr,"snmp_test(1): %s %s %s\n", SNMP_25, host, getoid);
   #endif
   free(buf);
   * stat = -1;
   return data;
   }
else{
   #ifdef SNMP_DEBUG
   fprintf(stderr,"snmp_test(1): %s %s %s\n", SNMP_26, host, getoid);
   #endif
   }


/* make PUD */
pdu = snmp_pdu_create(SNMP_MSG_GET);
if(!read_objid(getoid, anOID, &anOID_len)){
   snmp_perror(getoid);
//   #ifdef SNMP_DEBUG
   fprintf(stderr,"snmp_test(2): %s %s %s\n", SNMP_27, host, getoid);
//   #endif
   data = safe_sprintf(data, BUF_MAX,"%s %s %s\n", SNMP_27, host, getoid);
   free(buf);
   * stat = -1;
   return data;
   }

if((tp = get_tree(anOID, anOID_len, get_tree_head()))==NULL){
   #ifdef SNMP_DEBUG
   fprintf(stderr,"snmp_test(3): %s %s %s\n", SNMP_28, host, getoid);
   #endif
   data = safe_sprintf(data, BUF_MAX,"%s %s %s\n", SNMP_28, host, getoid);
   free(buf);
   * stat = -1;
   return data;
   }

// debug infomationi
#ifdef SNMP_DEBUG
print_mib_tree(stdout, tp, 1000000);
print_objid(anOID, anOID_len);
print_description(anOID, anOID_len, 1000000);
#endif


snmp_add_null_var(pdu, anOID, anOID_len);

/* send & recv session */
status = snmp_synch_response(ss, pdu, &response);


/* get session print */
if(status == STAT_SUCCESS && response->errstat == SNMP_ERR_NOERROR){
   for(vars = response->variables; vars; vars = vars->next_variable){
      snprint_value(buf, MIB_BUFLEN, vars->name, vars->name_length, vars);
      #ifdef SNMP_DEBUG
      printf("%s\n", buf);
      print_variable(vars->name, vars->name_length, vars);
      #endif
      } 
   }
else{
   if(status == STAT_SUCCESS){
      sprintf(buf,"snmp error code: %s\n", snmp_errstring(response->errstat));
      data = safe_memcpy(data, buf, BUF_MAX);
      #ifdef SNMP_DEBUG
      fprintf(stderr,"snmp_test(4): %s\n", data);
      #endif
      free(buf);
      snmp_close(ss);
      * stat = -1;
      return data;
      }
   else{
      snmp_sess_perror("snmpget", ss);
      data = safe_sprintf(data, BUF_MAX,"%s %s %s\n", SNMP_29, host, getoid);
      #ifdef SNMP_DEBUG
      fprintf(stderr,"snmp_test(5): %s %s %s\n", SNMP_29, host, getoid);
      #endif
      free(buf);
      snmp_close(ss);
      * stat = -1;
      return data;
      }
   }

/* session close */
if(response){
   #ifdef SNMP_DEBUG
   fprintf(stderr,"snmp_test(5-2): %s %s %s\n", "session close", host, getoid);
   #endif
   snmp_free_pdu(response);
   snmp_close(ss);
   }


if(opt != 0){ 
   if(* stat >= 0){
      if(0 == memcmp(buf, "Gauge32: ", 9)){
         * chk = 1;                          // returnd chk
         if(9 < (int)strlen(buf)){
            data = delim_get(buf, data, ' ', &ret, 1);
            #ifdef SNMP_DEBUG
            printf("Gauge32 OUT DATA = <%s>\n", data);
            #endif
            }
         }
      else if(0 == memcmp(buf, "Counter32: ", 11)){
         * chk = 2;                          // returnd chk
         if(11 < (int)strlen(buf)){
            data = delim_get(buf, data, ' ', &ret, 1);
            #ifdef SNMP_DEBUG
            printf("Counter32 OUT DATA = <%s>\n", data);
            #endif
            }
         }
      else if(0 == memcmp(buf, "INTEGER: ", 9)){
         * chk = 3;                          // returnd chk
         if(9 < (int)strlen(buf)){
            if(opt > 1){
               if(0 < char_point(buf, '(', 1) || 0 < char_point(buf, ')', 1)){
                  strtok_r(buf, "(", &tmp);
                  data = safe_memcpy(data, strtok_r(NULL, ")", &tmp), BUF_MAX);
                  #ifdef SNMP_DEBUG
                  printf("INTEGER() OUT DATA = <%s>\n", data);
                  #endif
                  }
               else{ 
                  data = delim_get(buf, data, ' ', &ret, 1);
                  #ifdef SNMP_DEBUG
                  printf("INTEGER OUT DATA opt2 = <%s> \n", data);
                  #endif
                  }
               }
            else{
               data = delim_get(buf, data, ' ', &ret, 1);
               #ifdef SNMP_DEBUG
               printf("INTEGER OUT DATA opt1 = %s\n", data);
               #endif
               }
            }
         }
      else{  /* STRING or ... */
         * chk = 4;                          // returnd chk
         int sta = char_point(buf, ':', 1);
         int sto = (int)strlen(buf);
         if(sta > 1 && buf[sta + 1] == ' ' && sto > 3){
            data = safe_memcpy(data, (strchr(buf, ':'))+1, BUF_MAX);
            data = delim_get(buf, data, ' ', &ret, 1);
            #ifdef SNMP_DEBUG
            printf("STRING or... DATA = <%s>\n", data);
            #endif
            }
         else{
            if(sto > 1){
               data = safe_memcpy(data, buf, BUF_MAX);
               #ifdef SNMP_DEBUG
               printf("NOT STRING or... DATA = <%s>\n", data);
               #endif
               }
            else{
               data = safe_memcpy(data, "NOT", BUF_MAX);
               #ifdef SNMP_DEBUG
               printf("NOT STRING or... DATA = <%s>\n", data);
               #endif
               }
            }
         }
      }
   else{
      data = safe_memcpy(data, buf, BUF_MAX);
      #ifdef SNMP_DEBUG
      printf("-ERROR DATA = <%s>\n", data);
      #endif
      }
   }
else{
   data = safe_memcpy(data, buf, BUF_MAX);
   }

free(buf);
return data;
}



 






