// sitar.h
// $Id: sitar.h,v 1.15 2007/11/14 04:44:23 sendan Exp $
// masashi shimakura

#ifndef _SITAR_H_
  #define _SITAR_H_

  #define CL_VAR "sitar-1.1.10"
  #define CONF_PATH "/etc/sitar.conf"

  #define BUF_LEN  256 
  #define BUF_DEFLEN 128
  #define BUF_MAX  (1024 * 1024 * 2)

  #define BUF_SLEN 128
  #define BUF_COM  128
  #define IP_LEN   128
  #define B_LEN    256      // Usually 64 gd.td.tcount (for thread count max)
  #define B_MAX    2048    // Usually 1024 gd.td.tbufmax (for thread buf size max)
  #define TIME_OUT 60
  #define INT_PLUS 10
// ALGET でファイルを分断する
  #define FILE_LEN 1024


/* print conf */
  #define PRINT_CONF

//  #define LIFE_DEBUG
//  #define MYPEXEC_DEBUG 
//  #define MUTEX_BUG
//  #define MAIL_MUTEX
//  #define MALLOC_BUG
//  #define FREE_BUG
//  #define THREAD_BUG
//  #define DATA_BUG
//  #define SOCKET_BUG
//  #define SOCKET_SENDBUG
//  #define SOCKET_RECVBUG
//  #define MONITOR_BUG

//  #define FILE_DEBUG 
//  #define SET_DEBUG
//  #define MYCHMEM_DEBUG
//  #define GETCOM_DEBUG
//  #define CONFIGFILE_DEBUG
//  #define STATFILE_DEBUG
//  #define RESOLV_DEBUG
//  #define SCAN_PORT_DEBUG
//  #define SNMP_DEBUG
//  #define GETFILE_TIME_DEBUG


  typedef struct global_data global_data_t;

   struct global_data {

     struct thread_data{
        char ** mutex_name;
        char ** middle_name;
        int tcount;
        int tbufmax;
        int * fdstat;
        char * middle_id;
        }td;

     struct my_sock{
        int sk;
        int ls;
        struct sockaddr_in my_addr;
        unsigned int my_addrlen;
        char * ip_addr;           /* active */
        char * ip2_addr;          /* active */
        int port;
        int port2;
        }ip;

     struct set_conf{
        char * chA;           /* active swap */
        }sc;

     struct mail_data{
        char * ch_MailCc;     /* active */
        }smtp;

     struct life_data{
        char onoff;
        }ld;

     struct buff_set{
        char * c_name;        /* active */
        char * myfile;        /* active swap */
        char * c_info;        /* active */
        int life_int;
        int life_los;
        int my_pid;
        int restart_count;
        int stop_count;
        int break_count;
        int bat_int;
        int bat2_int;
        }bf;

     struct file_path{ 
        char * conf_path;            /* read onlly */
        char * command_path;         /* active */
        char * bat_filename;         /* active */
        char * bat_filename_2;       /* active */
        char * bat_filestat;         /* active */
        char * bat2_filename;        /* active */
        char * bat2_filename_2;      /* active */
        char * bat2_filestat;        /* active */
        char * update_com;           /* active */
        }fi;

     struct scan_data {
        char * swap;                 /* active swap */
        char * scan_all;             /* active swap */
        }sd;

     };



   typedef struct private_data private_data_t;

   struct private_data{
      struct scan_buf{
         int fdno;
         char * swap;             /* active swap */
         char * ch_tool;          /* active swap */
         char * ch_com;           /* active swap */
         char * ch_plai;          /* active swap */
         char * ch_stat;          /* active swap */
         char * ch_prot;          /* active swap */
         char * ch_host;          /* sctive swap */
         char * ch_port;          /* active swap */
         char * ch_port_h;        /* active swap */
         char * ch_port_m;        /* active swap */
         char * ch_timeout;       /* active swap */
         char * ch_timeout_h;     /* active swap */
         char * ch_timeout_m;     /* active swap */
         char * ch_data;          /* active swap */
         char * ch_info;          /* active swap */
         char * ch_free1;         /* active swap */
         char * ch_free2;         /* active swap */
         char * ch_free3;         /* active swap */
         char * ch_free4;         /* active swap */
         char * swap_2;           /* active swap */
         char * scan_all;           /* active swap */
         int port;
         int timeout; 
         int check_stat;
         }sb;
      };

   typedef struct swap_array swap_array_t;

   struct swap_array{
      int main_buf_err; 
      int * buf_err;
      pthread_t  * pt;
      int * count;
      char *** swap_data;           // active swap 
      char ** tmp_data;             // active swap 
      };


  #include "./prototype.h"

#endif

