// scan_urlport.c
// $Id: scan_urlport.c,v 1.1.1.1 2007/09/19 05:49:54 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include<sys/stat.h>
#include<errno.h>

#include "sitar_scan.h"
#include "sitar_com.h"
#include"almemsys.h"
#include "jpreturn.h"

// struct buf_data bd;


/* 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_url_connect(int, char *, char *, int);
unsigned long resolvename(char *, char *);
*/

int urldompass(char *, char *, char *, int); 
char * set_request(char *, char *, char *);
int check_recvdata(char *, char *);

 
int urldompass(char * url_data, char * url_dom, char * url_pass, int datain)
{
int ret;
int count, count2;

if(datain < BUF_SLEN){

   if(NULL == strchr(url_data, '/')){
      self_memcpy(url_dom, url_data, BUF_SLEN);
      url_pass[0] = (char)0x00;
      ret = 1;
      return(ret);
      }

   else {
      for(count = 0; datain >= count; count++){
         if(url_data[count] != '/'){
            url_dom[count] = url_data[count];
            }
         else {
            url_dom[count] = (char)0x00;
            break;
            }
         }
      count++;
      if(url_data[count]!=(char)0x00){
         for(count2 = 0; datain >= count; count++){
            if(url_data[count] != (char)0x00){
               url_pass[count2] = url_data[count];
               }
            else {
               url_pass[count2] = (char)0x00;
               break;
               }
            count2++;
            } 
         }
      else {
         url_pass[0] = (char)0x00;
         ret = 1;
         return(ret);
         }
      ret = 1;
      return(ret);
      }

   }
ret = -1;
return(ret);
} 




unsigned long resolvename(char *name, int timeout)
{
unsigned long ret;
char * recdata;
char * sendcom;

if((recdata = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){ exit(1);}
if((sendcom = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){ exit(1);}

sendcom = safe_sprintf(sendcom, BUF_MAX,"%s %s",
  "/usr/local/zither/bin/resolv", name);

#ifdef RESOLV_BUG
printf("RESOLV: resolvname(): %s\n", sendcom);
#endif

recdata = execom(sendcom, recdata, timeout, 1);

ret = 0;
if(0 == memcmp(recdata, COM_1, 20)){
   #ifdef RESOLV_BUG
   fprintf(stderr,"RESOLV: resolvname(): %s %s\n", SOCK_2, name);
   #endif
   ret = 0;
   }
else{
   ret = (unsigned long)inet_addr(recdata);
   }

free(recdata);
free(sendcom);
return(ret);
}





char * set_request(char * backdata, char * url_dom, char * url_pass)
{

backdata = safe_sprintf(backdata, BUF_MAX,
"HEAD /%s HTTP/1.0\nHost: %s\nUser-Agent: zither-1.1.1(monitorring server)\nPragma: no-cache\nCache-Control: no-cache\r\n\r\n", url_pass, url_dom);

#ifdef URL_BUG
printf("URL: set_request(): SEND HEADERS\n");
printf("%s", backdata);
#endif

return backdata;
}



int check_recvdata(char * recvdata, char * data)
{
int ret, dret;
int count = 0;
int inc = 0;
char * swap;

dret = 0;

if((swap = (char *)calloc(BUF_DEFLEN, sizeof(char)))==NULL){ exit(1);}

ret = -1;
for(count = 0; inc == 0; count++){
   data[count] = recvdata[count];
   if(data[count] == '\n'){
      inc = 1;
      }
   if(count >= BUF_LEN){
      inc = 1;
      }
   }
if(count > 1){
   count = count - 2;
   data[count] = (char)0x00;

   #ifdef URL_BUG
   printf("-1--%s---\n", data);
   #endif
   swap = delim_get(data, swap, ' ', &dret, 1);
   #ifdef URL_BUG
   printf("-2--%s---\n", swap);
   #endif
   if(3 == (int)strlen(swap)){
      if('2' == swap[0]){
         #ifdef URL_BUG
         printf("-200--%c---\n", swap[0]);
         #endif
         ret = 2;
         }
      else if('3' == swap[0]){
         #ifdef URL_BUG
         printf("-300--%c---\n", swap[0]);
         #endif
         ret = 3;
         }
      else if('1' == swap[0]){
         #ifdef URL_BUG
         printf("-100--%c---\n", swap[0]);
         #endif
         ret = -1;
         }
      else if('4' == swap[0]){
         #ifdef URL_BUG
         printf("-400--%c---\n", swap[0]);
         #endif
         ret = -1;
         }
      else if('5' == swap[0]){
         #ifdef URL_BUG
         printf("-500--%c---\n", swap[0]);
         #endif
         ret = -1;
         }
      else{
         #ifdef URL_BUG
         printf("-other--%c---\n", swap[0]);
         #endif
         ret = -1;
         }
      }
   else{
      ret = -1;
      }
   }

else{
   data = safe_sprintf(data, BUF_MAX, "%s", URL_1);
   ret = -1;
   } 

free(swap);
return(ret);
}




/*----------------- SCAN TCP CONNECT --------------------*/
char * scan_url_connect(int port, char * url_data, char * backdata, int timeout, int * pst)
{
int sk, re, stat, ret;
char ipa[IP_LEN];
char dom[1024];
char pass[1024];
char * ip_addr = ipa;
char * url_dom = dom;
char * url_pass = pass;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;
int retval;
int arglen = sizeof(int);
int dcount = 0;
char * recvdata = NULL;
char * senddata = NULL;

ret = -1;
errno = 0;

if((recvdata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((senddata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}


stat = urldompass(url_data, url_dom, url_pass, strlen(url_data)); 

if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"scan_url URL=%s Port=%d tcp %s", url_data, port, SOCK_1);
   backdata=safe_sprintf(backdata, BUF_MAX,
    "URL=%s Port=%d tcp %s", url_data, port, SOCK_1);
   #ifdef URL_BUG
   printf("URL: scan_url_connect(): NOT CLEATE SOCKETS %s\n", backdata);
   #endif
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
if((my_addr.sin_addr.s_addr = resolvename(url_dom,timeout))== (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s %s %d\n",
    SOCK_2, url_dom, (int)my_addr.sin_addr.s_addr);
   #ifdef URL_BUG
   printf("URL: scan_url_connect():  NOT RESOLV NAME %s\n", backdata);
   #endif
   close(sk);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

ip_addr = inet_ntoa(my_addr.sin_addr);
#ifdef URL_BUG
printf("URL: scan_url_connect(): %s\n", ip_addr);
#endif


fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long)&my_addr, sizeof(my_addr));

/* success */
if(re >= 0){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "URL=%s Port=%d %s", url_data, port, SOCK_5);
   #ifdef URL_BUG
   printf("URL: scan_url_connect(): CONNECT SUCCESS %s\n", backdate);
   printf("%s\n", backdata);
   #endif
   close(sk);
   * pst = 0;
   free(recvdata);
   free(senddata);
   return backdata;
   }


/* error EINPROGRESS */
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      if(retval == 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_data, port, SOCK_4);
         #ifdef URL_BUG
         printf("URL: scan_url_connect(): select time out BREAK- %d - %s\n", retval, backdata);
         #endif
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      if(retval >= 1){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_data, port, SOCK_3);
         #ifdef URL_BUG
         printf("URL: scan_url_connect(): select time succes BREAK-%d- %s\n", retval, backdata);
         #endif
         break;
         }
      }

/* error */
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      fprintf(stderr,"getsockopt() Errors!\n");
      }
   else{
      if(retval){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d Error! %s", url_data, port, SOCK_5);
         #ifdef URL_BUG
         printf("URL: scan_url_connect(): 1 SO_ERROR %d %s\n", retval, backdata);
         #endif
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_data, port, SOCK_3);
         senddata = set_request(senddata, url_dom, url_pass);
         #ifdef URL_BUG
         printf("URL: scan_url_connect(): set_request*send-%s- %s\n", senddata, backdata);
         #endif
         send(sk, senddata, strlen(senddata), 0);

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);

            if(retval < 0){
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s", url_data, port, URL_2);
               #ifdef URL_BUG
               printf("URL: scan_url_connect(): retval 0 ERR %s\n", backdata);
               #endif 
               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            if(retval == 0){
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s"
                , url_data, port, URL_3);
               #ifdef URL_BUG
               printf("URL: scan_url_connect(): retval 1 ERR %s\n", backdata); 
               #endif 
               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            if(retval >= 1){
               dcount = recv(sk, recvdata, BUF_LEN, 0);
               #ifdef URL_BUG
               printf("URL: scan_url_connect(): recv--%s-%d-\n", recvdata, dcount);
               #endif
               if(dcount < 1){
                  backdata=safe_sprintf(backdata,BUF_MAX,
                   "URL=%s Port=%d %s"
                   , url_data, port, URL_2);
                  ret = -1;
                  }
               else{
                  backdata = (char *)realloc(backdata, (dcount + 10) * sizeof(char));
                  ret = check_recvdata(recvdata, backdata);
                  #ifdef URL_BUG
                  printf("URL: scan_url_connect(): <2> %s\n", backdata);
                  #endif 
                  }
               close(sk);
               * pst = ret;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            }

         close(sk);
         * pst = ret;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      }
   }

backdata=safe_sprintf(backdata,BUF_MAX,
 "URL=%s Port=%d %s", url_data, port, SOCK_5);
#ifdef URL_BUG
printf("URL: scan_url_connect(): LAST %s\n", backdata); 
#endif 

close(sk);
* pst = -1;

free(recvdata);
free(senddata);
return backdata;

}







