// scan_tcpport.c
// $Id: scan_tcpport.c,v 1.1.1.1 2007/09/19 05:49:54 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<fcntl.h>

#include<sys/stat.h>
#include<errno.h>

#include "sitar_scan.h"
#include "sitar_com.h"
#include "almemsys.h"
#include "jpreturn.h"

/* 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_tcp_connect(int, char *, char *, int);
*/


/*----------------- SCAN TCP CONNECT --------------------*/
char * scan_tcp_connect(int port, char * ip_addr, char * backdata, int timeout, int * stat)
{
int sk, re;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;
int retval;
int arglen = sizeof(int);

errno = 0;

if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_1);
   * stat = -1;
   #ifdef TCP_BUG
   printf("TCP: scan_tcp_connect(): NOT CLEATE SOCKET %s\n", backdata);
   #endif
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
my_addr.sin_addr.s_addr = resolvename(ip_addr,timeout);
if(0 == (int)my_addr.sin_addr.s_addr){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s%s %d\n",
    SOCK_2, ip_addr, (int)my_addr.sin_addr.s_addr);
   #ifdef TCP_BUG
   printf("TCP: scan_tcp_connect(): NOT RESOLV NAME %s\n", backdata);
   #endif
   close(sk);
   * stat = -1;
   return backdata;
   }

#ifdef TCP_BUG
printf("TCP: scan_tcp_connetc(): start TCPCHECK ip_addr = %s\n", ip_addr);
#endif

fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long)&my_addr, sizeof(my_addr));

/* success */
if(re >= 0){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_3);
   #ifdef TCP_BUG
   printf("TCP: scan_tcp_connect(): CONNECT SUCCESS %s\n", backdata);
   #endif
   fcntl(sk, F_SETFL, 0);
   close(sk);
   * stat = 0;
   return backdata;
   }

/* error EINPROGRESS */
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;

   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      if(retval == 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d %s", ip_addr, port, SOCK_4);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connetc(): select time out BREAK-%d- %s\n", retval, backdata);
         #endif
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * stat = -1;
         return backdata;
         }
      if(retval >= 1){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_3);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connect(): select time succes BREAK-%d- %s\n", retval, backdata);
         #endif
         break;
         }
      }

   fcntl(sk, F_SETFL, 0);


/* error */
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      #ifdef TCP_BUG
      printf("TCP: scan_tcp_connect(): getsockopt() Errors!\n");
      #endif
      }
   else{
      if(retval){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_5);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connect(): 1 SO_ERROR %d -\n", retval);
         printf("%s\n", backdata);
         #endif
         close(sk);
         * stat = -1;
         return backdata;
         }
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_3);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connect(): -1 SO_ERROR %d -\n", retval);
         printf("%s\n", backdata);
         #endif
         close(sk);
         * stat = 0;
         return backdata;
         }
      }
   }


backdata=safe_sprintf(backdata,BUF_MAX,
 "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_6); 
#ifdef TCP_BUG
printf("TCP: scan_tcp_connect(): --- LAST END ---\n");
printf("%s\n", backdata);
#endif

close(sk);
* stat = -1;
return backdata;

}






