// scan_dhwport.c
// $Id: scan_dhwport.c,v 1.1.1.1 2007/09/19 05:49:54 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include<sys/stat.h>
#include<errno.h>

#include "sitar_scan.h"
#include "sitar_com.h"
#include "almemsys.h"
#include "jpreturn.h"


/* 0-> dhw exc command line 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_smtp_connect(int, char *, char *, int);
*/


/*----------------- SCAN DHW CONNECT --------------------*/
char * scan_dhw_connect(char * comand, int port, char * url_dom, char * backdata, int timeout, int * pst)
{
int sk, re, ret;
char ipa[IP_LEN];
char * ip_addr = ipa;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;
int retval;
int arglen = sizeof(int);
int dcount = 0;
char * recvdata = NULL;
char * senddata = NULL;

// struct buf_data bd;

ret = -1;
errno = 0;

#ifdef DHW_BUG
printf("DHW: scan_dhw_connect(): DHW COMMAND %s\n", comand);
#endif

if((recvdata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((senddata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}

if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"scan_dhw URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   backdata=safe_sprintf(backdata, BUF_MAX,
    "URL=%s Port=%d tcp %s", url_dom, port, SOCK_1);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
if((my_addr.sin_addr.s_addr = resolvename(url_dom,timeout))== (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s %s %d\n",
    SOCK_2, url_dom, (int)my_addr.sin_addr.s_addr);
   close(sk);
   * pst = -1;
   free(recvdata);
   free(senddata);
   return backdata;
   }

ip_addr = inet_ntoa(my_addr.sin_addr);

fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long int)&my_addr, sizeof(my_addr));

#ifdef DHW_BUG
printf("DHW: scan_dhw_connect(): connect start %d %s %s %d\n", re, url_dom, ip_addr, port);
#endif

/* success */
if(re >= 0){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "URL=%s Port=%d %s", url_dom, port, SOCK_3);
   #ifdef DHW_BUG
   printf("DHW: scan_dhw_connect(): CONNECT SUCCESS %s\n", backdata);
   #endif
   close(sk);
   * pst = 0;
   free(recvdata);
   free(senddata);
   return backdata;
   }


/* error EINPROGRESS */
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      if(retval == 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_4);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(): select time out BREAK- %d - %s\n",
           retval, backdata);
         #endif
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      if(retval >= 1){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(): select time succes BREAK- %d - %s\n",
          retval, backdata);
         #endif
         break;
         }
      }

/* error */
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      fprintf(stderr,"getsockopt() Errors!\n");
      }
   else{
      if(retval){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d Error! %s", url_dom, port, SOCK_5);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(): 1 SO_ERROR %d -%s\n", retval, backdata);
         #endif
         close(sk);
         * pst = -1;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "URL=%s Port=%d %s", url_dom, port, SOCK_3);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(): 1 SO_ERROR else %d -%s\n", retval, backdata);
         #endif
         senddata=safe_sprintf(senddata, BUF_MAX,
          "%s\n\n", comand);
////////
//       senddata = set_smrequest(senddata);
         #ifdef DHW_BUG
         printf("DHW: scan_dhw_connect(): set_request*send-- %s --\n", senddata);
         #endif 
         send(sk, senddata, strlen(senddata), 0);

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);

            if(retval < 0){
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(): retval 0 ERR\n");
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s", url_dom, port, URL_2);
               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            if(retval == 0){
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(): retval 1 ERR\n"); 
               #endif 
               backdata=safe_sprintf(backdata,BUF_MAX,
                "URL=%s Port=%d %s"
                , url_dom, port, URL_3);

               close(sk);
               * pst = -1;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            if(retval >= 1){
               dcount = recv(sk, recvdata, BUF_LEN, 0);
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(): recv-- %s --\n", recvdata);
               #endif

               if(dcount < 1){
                  backdata = safe_sprintf(backdata,BUF_MAX,
                   "DHW COMMAND SUCCESS %d" , recvdata);
                  ret = 0;
                  #ifdef DHW_BUG
                  printf("DHW: scan_dhw_connect(): <%d>\n", ret);
                  #endif
                  }
               else{
//////////////
//                ret = check_smrecvdata(recvdata);
                  ret = -1;
                  #ifdef DHW_BUG
                  printf("DHW: scan_dhw_connect(): <%d><2> %s\n", ret, backdata);
                  #endif
                  }

               if(ret == -1){
                  backdata=safe_memcpy(backdata, recvdata, BUF_LEN);
                  }
               #ifdef DHW_BUG
               printf("DHW: scan_dhw_connect(): %d <2> %s %d\n", ret, backdata);
               #endif
               close(sk);
               * pst = ret;
               free(recvdata);
               free(senddata);
               return backdata;
               }
            }

         close(sk);
         * pst = ret;
         free(recvdata);
         free(senddata);
         return backdata;
         }
      }
   }

backdata=safe_sprintf(backdata,BUF_MAX,
 "URL=%s Port=%d %s", url_dom, port, SOCK_6);
#ifdef DHW_BUG
printf("DHW: scan_dhw_connect(): not connection last out\n");
#endif

close(sk);
* pst = -1;

free(recvdata);
free(senddata);
return backdata;

}







