package server;


/**
 * 爆弾を表すクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/21 16:26:35
 */
public class Bomb {
    /**
     * 爆発する時刻
     */
    private long blowTime;

    /**
     * 列
     */
    private byte col;

    /**
     * 列方向の移動速度
     */
    private int dc;

    /**
     * 行方向の移動速度
     */
    private int dr;

    /**
     * 蹴ったプレイヤ
     */
    private Player kicker;

    /**
     * 番号 
     */
    final private int number;

    /**
     * 置いたプレイヤ
     */
    final private Player parent;

    /**
     * 火力
     */
    final private byte power;

    /**
     * 行
     */
    private byte row;

    /**
     * アニメーションが停止する時刻
     */
    private long stopTime;

    /**
     * 新しいボールを初期化します。
     * @param number 番号
     * @param parent 置いたプレイヤ
     * @param power 火力
     */
    public Bomb(int number, Player parent, byte power) {
        this.number = number;
        this.blowTime = System.currentTimeMillis() + ServerConstants.SERVER_BOMB_BLOW_TIME;
        this.parent = parent;
        this.power = power;
    }

    /**
     * @return 爆弾が爆発する時刻
     */
    public long getBlowTime() {
        return this.blowTime;
    }

    /**
     * @return 列
     */
    public byte getCol() {
        return this.col;
    }

    /**
     * @return 列方向の移動速度 
     */
    public int getDc() {
        return this.dc;
    }

    /**
     * @return 行方向の移動速度
     */
    public int getDr() {
        return this.dr;
    }

    /**
     * @return 蹴ったプレイヤ
     */
    public Player getKicker() {
        return this.kicker;
    }

    /**
     * @return 番号
     */
    public int getNumber() {
        return this.number;
    }

    /**
     * @return 置いたプレイヤ
     */
    public Player getParent() {
        return this.parent;
    }

    /**
     * @return 火力
     */
    public byte getPower() {
        return this.power;
    }

    /**
     * @return 行
     */
    public byte getRow() {
        return this.row;
    }

    /**
     * @return アニメーションが停止する時刻
     */
    public long getStopTime() {
        return this.stopTime;
    }

    /**
     * @param col 列
     */
    public void setCol(byte col) {
        this.col = col;
    }

    /**
     * @param dc 列方向の移動速度
     */
    public void setDc(int dc) {
        this.dc = dc;
    }

    /**
     * @param dr 行方向の移動速度
     */
    public void setDr(int dr) {
        this.dr = dr;
    }

    /**
     * @param kicker 蹴ったプレイヤ
     */
    public void setKicker(Player kicker) {
        this.kicker = kicker;
    }

    /**
     * @param row 行
     */
    public void setRow(byte row) {
        this.row = row;
    }

    /**
     * @param stopTime アニメーションが停止する時刻
     */
    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    /**
     * @param blowTime 爆発する時刻
     */
    public void setBlowTime(long blowTime) {
        this.blowTime = blowTime;
    }
}
