package common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 文字列の置換を行なうユーティリティクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/22 13:52:46
 */
public class Replace {
    /**
     * 文字列を置換します。
     * @param string 文字列
     * @param before 置換前
     * @param after 置換後
     * @return 文字列
     */
    public static String replace(String string, String before, String after) {
        Pattern pattern = Pattern.compile(before);
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll(after);
    }
}
