package client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Map;
import javax.swing.JPanel;

/**
 * 補助情報を表示するためのパネルです。
 * @author Kumano Tatsuo
 * Created on 2005/01/21 11:43:04
 */
public class SubPanel extends JPanel implements Runnable {
    /**
     * ゲーム
     */
    final private Game game;

    /**
     * 補助情報を表示するためのパネルを初期化します。
     * @param game ゲーム
     */
    public SubPanel(final Game game) {
        this.setPreferredSize(new Dimension(ClientConstants.SUB_PANEL_WIDTH,
                ClientConstants.SCREEN_HEIGHT));
        this.game = game;
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D) graphics;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        int i = 1;
        for (Map.Entry<Integer, Player> entry : this.game.getPlayers().entrySet()) {
            int number = entry.getKey();
            Player player = entry.getValue();
            if (player.isPlaying()) {
                final int x1 = 20;
                final int x2 = 120;
                g.setColor(Color.GRAY);
                g.drawString(player.getPlayerName(), x1 - 1, i * 20 - 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(player.getPlayerName(), x1 + 1, i * 20 + 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(player.getPlayerName(), x1 - 1, i * 20 + 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(player.getPlayerName(), x1 + 1, i * 20 - 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2 - 1, i * 20 - 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2 + 1, i * 20 + 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2 - 1, i * 20 + 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2 + 1, i * 20 - 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.setColor(Color.BLACK);
                g.drawString(player.getPlayerName(), x1, i * 20 - 1 + ClientConstants.TOP_MARGIN
                        - 4);
                g.drawString(player.getPlayerName(), x1 - 1, i * 20 + ClientConstants.TOP_MARGIN
                        - 4);
                g.drawString(player.getPlayerName(), x1, i * 20 + 1 + ClientConstants.TOP_MARGIN
                        - 4);
                g.drawString(player.getPlayerName(), x1 + 1, i * 20 + ClientConstants.TOP_MARGIN
                        - 4);
                g.drawString(String.valueOf(player.getRate()), x2, i * 20 - 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2 - 1, i * 20
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2, i * 20 + 1
                        + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2 + 1, i * 20
                        + ClientConstants.TOP_MARGIN - 4);
                g.setColor(Color.WHITE);
                g.drawString(player.getPlayerName(), x1, i * 20 + ClientConstants.TOP_MARGIN - 4);
                g.drawString(String.valueOf(player.getRate()), x2, i * 20
                        + ClientConstants.TOP_MARGIN - 4);
                if (number == this.game.getNumber1()) {
                    drawTriangle(g, i, Color.RED);
                } else if (number == this.game.getNumber2()) {
                    drawTriangle(g, i, Color.YELLOW);
                }
                ++i;
            }
        }
    }

    /**
     * 三角形を描画します。
     * @param g グラフィクスコンテキスト
     * @param i 描画する位置
     * @param color 色
     */
    private void drawTriangle(Graphics2D g, int i, Color color) {
        Polygon polygon = new Polygon(new int[] { 5, 5, 17 }, new int[] {
                i * 20 + ClientConstants.TOP_MARGIN - 14, i * 20 + ClientConstants.TOP_MARGIN - 2,
                i * 20 + ClientConstants.TOP_MARGIN - 8 }, 3);
        g.setColor(color);
        g.fill(polygon);
        g.setColor(Color.BLACK);
        g.draw(polygon);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(ClientConstants.SUB_PANEL_REPAINT_WAIT_TIME);
                this.repaint();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
