
import java.applet.Applet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.swing.JButton;
import client.ClientConstants;
import client.Game;
import client.KeyHandler;
import client.MainPanel;
import client.SubPanel;
import common.CommonConstants;

/**
 * クライアントのアプレットです。 
 * @author Kumano Tatsuo
 * Created on 2005/01/30 11:32:06
 */
public class ClientApplet extends Applet {
    public void start() {
        try {
            final String host = "zenjiro.dyndns.org";
            final Socket socket1 = new Socket(host, CommonConstants.CONNECTION_PORT);
            final DataInputStream in1 = new DataInputStream(socket1.getInputStream());
            final DataOutputStream out1 = new DataOutputStream(socket1.getOutputStream());
            final Socket socket2 = new Socket(host, CommonConstants.CONNECTION_PORT);
            final DataInputStream in2 = new DataInputStream(socket2.getInputStream());
            final DataOutputStream out2 = new DataOutputStream(socket2.getOutputStream());
            final Game game = new Game(in1, in2);
            game.start();
            final KeyHandler handler = new KeyHandler(out1, out2);
            handler.start();
            MainPanel mainPanel = new MainPanel(in1, out1, in2, out2, handler, game);
            final SubPanel subPanel = new SubPanel(game);
            new Thread(subPanel).start();
            this.setLayout(null);
            mainPanel.setBounds(0, 0, ClientConstants.MAIN_PANEL_WIDTH, ClientConstants.SCREEN_HEIGHT);
            this.add(mainPanel);
            subPanel.setBounds(ClientConstants.MAIN_PANEL_WIDTH, 0, ClientConstants.SUB_PANEL_WIDTH,
                    ClientConstants.SCREEN_HEIGHT - ClientConstants.GRID_HEIGHT);
            this.add(subPanel);
            this.addKeyListener(handler);
            new Thread(mainPanel).start();
            String documentBase = getDocumentBase().toString();
            if (documentBase.contains("?")) {
                String[] args = documentBase.split("[?]")[1].split("&");
                if (args.length == 4) {
                    if (args[0].split("=").length == 2) {
                        String name1 = args[0].split("=")[1];
                        String pass1 = args[1].split("=")[1];
                        out1.writeByte(CommonConstants.COMMAND_MY_NAME);
                        out1.writeUTF(name1);
                        out1.writeByte(CommonConstants.COMMAND_MY_PASS);
                        out1.writeUTF(pass1);
                    }
                    if (args[2].split("=").length == 2) {
                        String name2 = args[2].split("=")[1];
                        String pass2 = args[3].split("=")[1];
                        out2.writeByte(CommonConstants.COMMAND_MY_NAME);
                        out2.writeUTF(name2);
                        out2.writeByte(CommonConstants.COMMAND_MY_PASS);
                        out2.writeUTF(pass2);
                    }
                    if (args[0].split("=").length == 2 || args[2].split("=").length == 2) {
                        final JButton button = new JButton("押してください。");
                        button.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                button.setSize(0, 0);
                            }
                        });
                        button.addKeyListener(handler);
                        button.setBounds(ClientConstants.MAIN_PANEL_WIDTH, ClientConstants.SCREEN_HEIGHT
                                - ClientConstants.GRID_HEIGHT, ClientConstants.SUB_PANEL_WIDTH,
                                ClientConstants.GRID_HEIGHT);
                        this.add(button);
                    }
                }
            }
        } catch (IOException e) {
            System.err.println("サーバが起動していないようです。");
            System.err.println("しばらくしてから、アプリケーションを再起動してみてください。");
        }
    }

    public void stop() {
        super.stop();
        System.exit(0);
    }
}
