/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.ml.Message;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

public class DefaultRgtLabelProvider
implements RootGameTreeLabelProvider {
    private static final Message LB_DISPLAY_NAME = new Message(DefaultRgtLabelProvider.class, "lbDisplayName");
    private static final Message LB_VERSUS = new Message(DefaultRgtLabelProvider.class, "lbVersus");
    private static final Message LB_UNKNOWN = new Message(DefaultRgtLabelProvider.class, "lbUnknown");

    public String getLabel(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Sequence sequence = rootGameTree.getSequence();
        String string = this.composeGameName(sequence);
        if (!string.equals("")) {
            return string;
        }
        string = this.composeEventInfo(sequence);
        if (!string.equals("")) {
            return string;
        }
        return this.composePlayerInfo(sequence);
    }

    private String composeGameName(Sequence sequence) {
        return BasicFinder.findDatum(sequence, SgfId.GAME_NAME);
    }

    private String composeEventInfo(Sequence sequence) {
        Node node = BasicFinder.findNode(sequence, SgfId.EVENT);
        if (node != null) {
            return this.compose(node, SgfId.EVENT, SgfId.ROUND);
        }
        return "";
    }

    private String composePlayerInfo(Sequence sequence) {
        Node node = BasicFinder.findNode(sequence, SgfId.PLAYER_WHITE);
        Node node2 = node = node != null ? node : BasicFinder.findNode(sequence, SgfId.PLAYER_BLACK);
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.compose(node, SgfId.PLAYER_WHITE, SgfId.WHITE_RANK);
        stringBuilder.append("".equals(string) ? LB_UNKNOWN.get() : string);
        stringBuilder.append(' ').append(LB_VERSUS.get()).append(' ');
        String string2 = this.compose(node, SgfId.PLAYER_BLACK, SgfId.BLACK_RANK);
        stringBuilder.append("".equals(string2) ? LB_UNKNOWN.get() : string2);
        return stringBuilder.toString();
    }

    private String compose(Node node, SgfId sgfId, SgfId sgfId2) {
        String string = BasicFinder.findDatum(node, sgfId);
        if (node == null) {
            return "";
        }
        String string2 = BasicFinder.findDatum(node, sgfId2);
        return string2.equals("") ? string : string + " [" + string2 + "]";
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}

