/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pref;

import java.io.File;
import java.util.EnumSet;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.jface.pref.CheckGroupFieldEditor;
import org.unitarou.jface.pref.FileArrayCodec;
import org.unitarou.ml.Message;
import org.unitarou.yukinoshita.view.jface.dlg.ExplorerLikeFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.FileDialogStyle;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePreferencePage
extends FieldEditorPreferencePage {
    private static final Message NT_TITLE = new Message(FilePreferencePage.class, "ntTitle");

    public static PreferenceNode createPreferenceNode() {
        String string = FilePreferencePage.class.getName();
        return new PreferenceNode(string, NT_TITLE.get(), null, string);
    }

    public FilePreferencePage() {
        super(0);
    }

    @Override
    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.addField(new RadioGroupFieldEditor(IgoFileDialog.FILE_DIALOG_STYLE.id(), IgoFileDialog.FILE_DIALOG_STYLE.displayName(), 2, this.composeEnumSelector(FileDialogStyle.class), composite, true));
        File[] fileArray = File.listRoots();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        String[][] stringArray = new String[fileArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = fileArray[i].getAbsolutePath();
            stringArray[i] = new String[]{string, string};
        }
        this.addField(new CheckGroupFieldEditor<File>(ExplorerLikeFileChooser.IGNORE_DRIVES.id(), '[' + FileDialogStyle.ORIGINAL.toString() + ']' + ' ' + ExplorerLikeFileChooser.IGNORE_DRIVES.displayName(), composite, stringArray, 4, FileArrayCodec.instance()));
    }

    private <E extends Enum<E>> String[][] composeEnumSelector(Class<E> clazz) {
        EnumSet<Enum> enumSet = EnumSet.allOf(clazz);
        String[][] stringArray = new String[enumSet.size()][];
        int n = 0;
        for (Enum enum_ : enumSet) {
            stringArray[n] = new String[]{enum_.toString(), enum_.name()};
            ++n;
        }
        return stringArray;
    }
}

